/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.model;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.model.ExtraModelProvider;
import net.fabricmc.fabric.api.client.model.ModelAppender;
import net.fabricmc.fabric.api.client.model.ModelLoadingRegistry;
import net.fabricmc.fabric.api.client.model.ModelProviderContext;
import net.fabricmc.fabric.api.client.model.ModelProviderException;
import net.fabricmc.fabric.api.client.model.ModelResourceProvider;
import net.fabricmc.fabric.api.client.model.ModelVariantProvider;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelResolver;
import net.fabricmc.fabric.api.client.model.loading.v1.PreparableModelLoadingPlugin;
import net.fabricmc.fabric.impl.client.model.loading.ModelLoaderPluginContextImpl;
import net.minecraft.client.render.model.UnbakedModel;
import net.minecraft.client.util.ModelIdentifier;
import net.minecraft.resource.ResourceManager;
import net.minecraft.util.Identifier;

@Environment(value=EnvType.CLIENT)
public class ModelLoadingRegistryImpl
implements ModelLoadingRegistry {
    private final List<ExtraModelProvider> modelProviders = new ArrayList<ExtraModelProvider>();
    private final List<ModelAppender> modelAppenders = new ArrayList<ModelAppender>();
    private final List<Function<ResourceManager, ModelResourceProvider>> resourceProviderSuppliers = new ArrayList<Function<ResourceManager, ModelResourceProvider>>();
    private final List<Function<ResourceManager, ModelVariantProvider>> variantProviderSuppliers = new ArrayList<Function<ResourceManager, ModelVariantProvider>>();

    public ModelLoadingRegistryImpl() {
        PreparableModelLoadingPlugin.register((resourceManager, executor) -> CompletableFuture.completedFuture(resourceManager), this::onInitializeModelLoader);
    }

    private void onInitializeModelLoader(ResourceManager resourceManager, ModelLoadingPlugin.Context pluginContext) {
        Object provider;
        Consumer<Identifier> extraModelConsumer = xva$0 -> pluginContext.addModels(new Identifier[]{xva$0});
        Consumer<ModelIdentifier> extraModelConsumer2 = xva$0 -> pluginContext.addModels(new Identifier[]{xva$0});
        ModelProviderContext resourceProviderContext = ((ModelLoaderPluginContextImpl)pluginContext).modelGetter::apply;
        for (ExtraModelProvider extraModelProvider : this.modelProviders) {
            extraModelProvider.provideExtraModels(resourceManager, extraModelConsumer);
        }
        for (ModelAppender modelAppender : this.modelAppenders) {
            modelAppender.appendAll(resourceManager, extraModelConsumer2);
        }
        for (Function function : this.resourceProviderSuppliers) {
            provider = (ModelResourceProvider)function.apply(resourceManager);
            pluginContext.resolveModel().register(arg_0 -> ModelLoadingRegistryImpl.lambda$onInitializeModelLoader$3((ModelResourceProvider)provider, resourceProviderContext, arg_0));
        }
        for (Function function : this.variantProviderSuppliers) {
            provider = (ModelVariantProvider)function.apply(resourceManager);
            ((ModelLoaderPluginContextImpl)pluginContext).legacyVariantProviders().register(arg_0 -> ModelLoadingRegistryImpl.lambda$onInitializeModelLoader$4((ModelVariantProvider)provider, resourceProviderContext, arg_0));
        }
    }

    @Override
    public void registerModelProvider(ExtraModelProvider provider) {
        this.modelProviders.add(provider);
    }

    @Override
    public void registerAppender(ModelAppender appender) {
        this.modelAppenders.add(appender);
    }

    @Override
    public void registerResourceProvider(Function<ResourceManager, ModelResourceProvider> providerSupplier) {
        this.resourceProviderSuppliers.add(providerSupplier);
    }

    @Override
    public void registerVariantProvider(Function<ResourceManager, ModelVariantProvider> providerSupplier) {
        this.variantProviderSuppliers.add(providerSupplier);
    }

    private static /* synthetic */ UnbakedModel lambda$onInitializeModelLoader$4(ModelVariantProvider provider, ModelProviderContext resourceProviderContext, ModelIdentifier modelId) {
        try {
            return provider.loadModelVariant(modelId, resourceProviderContext);
        }
        catch (ModelProviderException e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ UnbakedModel lambda$onInitializeModelLoader$3(ModelResourceProvider provider, ModelProviderContext resourceProviderContext, ModelResolver.Context resolverContext) {
        try {
            return provider.loadModelResource(resolverContext.id(), resourceProviderContext);
        }
        catch (ModelProviderException e) {
            throw new RuntimeException(e);
        }
    }
}

