/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.tag.client;

import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.impl.tag.client.ClientTagsLoader;
import net.minecraft.client.MinecraftClient;
import net.minecraft.registry.Registries;
import net.minecraft.registry.Registry;
import net.minecraft.registry.RegistryKey;
import net.minecraft.registry.entry.RegistryEntry;
import net.minecraft.registry.tag.TagKey;

@Environment(value=EnvType.CLIENT)
public class ClientTagsImpl {
    private static final Map<TagKey<?>, ClientTagsLoader.LoadedTag> LOCAL_TAG_HIERARCHY = new ConcurrentHashMap();

    public static <T> boolean isInWithLocalFallback(TagKey<T> tagKey, RegistryEntry<T> registryEntry) {
        return ClientTagsImpl.isInWithLocalFallback(tagKey, registryEntry, new HashSet<TagKey<T>>());
    }

    private static <T> boolean isInWithLocalFallback(TagKey<T> tagKey, RegistryEntry<T> registryEntry, Set<TagKey<T>> checked) {
        if (checked.contains(tagKey)) {
            return false;
        }
        checked.add(tagKey);
        Optional<Registry<T>> maybeRegistry = ClientTagsImpl.getRegistry(tagKey);
        if (maybeRegistry.isPresent() && maybeRegistry.get().getEntryList(tagKey).isPresent()) {
            return registryEntry.isIn(tagKey);
        }
        if (registryEntry.getKey().isEmpty()) {
            return false;
        }
        ClientTagsLoader.LoadedTag wt = ClientTagsImpl.getOrCreatePartiallySyncedTag(tagKey);
        if (wt.immediateChildIds().contains(((RegistryKey)registryEntry.getKey().get()).getValue())) {
            return true;
        }
        for (TagKey<?> key : wt.immediateChildTags()) {
            if (ClientTagsImpl.isInWithLocalFallback(key, registryEntry, checked)) {
                return true;
            }
            checked.add(key);
        }
        return false;
    }

    public static <T> Optional<? extends Registry<T>> getRegistry(TagKey<T> tagKey) {
        Optional maybeRegistry;
        Objects.requireNonNull(tagKey);
        if (MinecraftClient.getInstance() != null && MinecraftClient.getInstance().world != null && MinecraftClient.getInstance().world.getRegistryManager() != null && (maybeRegistry = MinecraftClient.getInstance().world.getRegistryManager().getOptional(tagKey.registry())).isPresent()) {
            return maybeRegistry;
        }
        return Registries.REGISTRIES.getOrEmpty(tagKey.registry().getValue());
    }

    public static <T> Optional<RegistryEntry<T>> getRegistryEntry(TagKey<T> tagKey, T entry) {
        Optional<Registry<T>> maybeRegistry = ClientTagsImpl.getRegistry(tagKey);
        if (maybeRegistry.isEmpty() || !tagKey.isOf(maybeRegistry.get().getKey())) {
            return Optional.empty();
        }
        Registry<T> registry = maybeRegistry.get();
        Optional maybeKey = registry.getKey(entry);
        return maybeKey.map(arg_0 -> registry.entryOf(arg_0));
    }

    public static ClientTagsLoader.LoadedTag getOrCreatePartiallySyncedTag(TagKey<?> tagKey) {
        ClientTagsLoader.LoadedTag loadedTag = LOCAL_TAG_HIERARCHY.get(tagKey);
        if (loadedTag == null) {
            loadedTag = ClientTagsLoader.loadTag(tagKey);
            LOCAL_TAG_HIERARCHY.put(tagKey, loadedTag);
        }
        return loadedTag;
    }
}

