/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.event.player;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.block.BlockState;
import net.minecraft.block.entity.BlockEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public final class PlayerBlockBreakEvents {
    public static final Event<Before> BEFORE = EventFactory.createArrayBacked(Before.class, listeners -> (world, player, pos, state, entity) -> {
        for (Before event : listeners) {
            boolean result = event.beforeBlockBreak(world, player, pos, state, entity);
            if (result) continue;
            return false;
        }
        return true;
    });
    public static final Event<After> AFTER = EventFactory.createArrayBacked(After.class, listeners -> (world, player, pos, state, entity) -> {
        for (After event : listeners) {
            event.afterBlockBreak(world, player, pos, state, entity);
        }
    });
    public static final Event<Canceled> CANCELED = EventFactory.createArrayBacked(Canceled.class, listeners -> (world, player, pos, state, entity) -> {
        for (Canceled event : listeners) {
            event.onBlockBreakCanceled(world, player, pos, state, entity);
        }
    });

    private PlayerBlockBreakEvents() {
    }

    @FunctionalInterface
    public static interface Canceled {
        public void onBlockBreakCanceled(World var1, PlayerEntity var2, BlockPos var3, BlockState var4, @Nullable BlockEntity var5);
    }

    @FunctionalInterface
    public static interface After {
        public void afterBlockBreak(World var1, PlayerEntity var2, BlockPos var3, BlockState var4, @Nullable BlockEntity var5);
    }

    @FunctionalInterface
    public static interface Before {
        public boolean beforeBlockBreak(World var1, PlayerEntity var2, BlockPos var3, BlockState var4, @Nullable BlockEntity var5);
    }
}

