/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.entity;

import com.google.common.collect.MapMaker;
import com.mojang.authlib.GameProfile;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.UUID;
import net.fabricmc.fabric.impl.event.interaction.FakePlayerNetworkHandler;
import net.minecraft.block.entity.SignBlockEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.damage.DamageSource;
import net.minecraft.entity.passive.AbstractHorseEntity;
import net.minecraft.inventory.Inventory;
import net.minecraft.network.packet.c2s.play.ClientSettingsC2SPacket;
import net.minecraft.scoreboard.AbstractTeam;
import net.minecraft.screen.NamedScreenHandlerFactory;
import net.minecraft.server.network.ServerPlayerEntity;
import net.minecraft.server.world.ServerWorld;
import net.minecraft.stat.Stat;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.Nullable;

public class FakePlayer
extends ServerPlayerEntity {
    public static final UUID DEFAULT_UUID = UUID.fromString("41C82C87-7AfB-4024-BA57-13D2C99CAE77");
    private static final GameProfile DEFAULT_PROFILE = new GameProfile(DEFAULT_UUID, "[Minecraft]");
    private static final Map<FakePlayerKey, FakePlayer> FAKE_PLAYER_MAP = new MapMaker().weakValues().makeMap();

    public static FakePlayer get(ServerWorld world) {
        return FakePlayer.get(world, DEFAULT_PROFILE);
    }

    public static FakePlayer get(ServerWorld world, GameProfile profile) {
        Objects.requireNonNull(world, "World may not be null.");
        Objects.requireNonNull(profile, "Game profile may not be null.");
        return FAKE_PLAYER_MAP.computeIfAbsent(new FakePlayerKey(world, profile), key -> new FakePlayer(key.world, key.profile));
    }

    protected FakePlayer(ServerWorld world, GameProfile profile) {
        super(world.getServer(), world, profile);
        this.networkHandler = new FakePlayerNetworkHandler(this);
    }

    public void tick() {
    }

    public void setClientSettings(ClientSettingsC2SPacket packet) {
    }

    public void increaseStat(Stat<?> stat, int amount) {
    }

    public void resetStat(Stat<?> stat) {
    }

    public boolean isInvulnerableTo(DamageSource damageSource) {
        return true;
    }

    @Nullable
    public AbstractTeam getScoreboardTeam() {
        return null;
    }

    public void sleep(BlockPos pos) {
    }

    public boolean startRiding(Entity entity, boolean force) {
        return false;
    }

    public void openEditSignScreen(SignBlockEntity sign, boolean front) {
    }

    public OptionalInt openHandledScreen(@Nullable NamedScreenHandlerFactory factory) {
        return OptionalInt.empty();
    }

    public void openHorseInventory(AbstractHorseEntity horse, Inventory inventory) {
    }

    private record FakePlayerKey(ServerWorld world, GameProfile profile) {
    }
}

