/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.datagen;

import com.google.gson.JsonElement;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.minecraft.block.Block;
import net.minecraft.data.DataOutput;
import net.minecraft.data.DataWriter;
import net.minecraft.data.client.BlockStateModelGenerator;
import net.minecraft.data.client.BlockStateSupplier;
import net.minecraft.data.client.ItemModelGenerator;
import net.minecraft.data.client.ModelProvider;
import net.minecraft.item.Item;
import net.minecraft.registry.Registries;
import net.minecraft.util.Identifier;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ModelProvider.class})
public class ModelProviderMixin {
    @Unique
    private FabricDataOutput fabricDataOutput;
    @Unique
    private static final ThreadLocal<FabricDataOutput> fabricDataOutputThreadLocal = new ThreadLocal();
    @Unique
    private static ThreadLocal<Map<Block, BlockStateSupplier>> blockStateMapThreadLocal = new ThreadLocal();

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void init(DataOutput output, CallbackInfo ci) {
        if (output instanceof FabricDataOutput) {
            FabricDataOutput fabricDataOutput;
            this.fabricDataOutput = fabricDataOutput = (FabricDataOutput)output;
        }
    }

    @Redirect(method={"run"}, at=@At(value="INVOKE", target="Lnet/minecraft/data/client/BlockStateModelGenerator;register()V"))
    private void registerBlockStateModels(BlockStateModelGenerator instance) {
        ModelProviderMixin modelProviderMixin = this;
        if (modelProviderMixin instanceof FabricModelProvider) {
            FabricModelProvider fabricModelProvider = (FabricModelProvider)((Object)modelProviderMixin);
            fabricModelProvider.generateBlockStateModels(instance);
        } else {
            instance.register();
        }
    }

    @Redirect(method={"run"}, at=@At(value="INVOKE", target="Lnet/minecraft/data/client/ItemModelGenerator;register()V"))
    private void registerItemModels(ItemModelGenerator instance) {
        ModelProviderMixin modelProviderMixin = this;
        if (modelProviderMixin instanceof FabricModelProvider) {
            FabricModelProvider fabricModelProvider = (FabricModelProvider)((Object)modelProviderMixin);
            fabricModelProvider.generateItemModels(instance);
        } else {
            instance.register();
        }
    }

    @Inject(method={"run"}, at={@At(value="INVOKE_ASSIGN", target="com/google/common/collect/Maps.newHashMap()Ljava/util/HashMap;", ordinal=0, remap=false)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void runHead(DataWriter writer, CallbackInfoReturnable<CompletableFuture<?>> cir, Map<Block, BlockStateSupplier> map) {
        fabricDataOutputThreadLocal.set(this.fabricDataOutput);
        blockStateMapThreadLocal.set(map);
    }

    @Inject(method={"run"}, at={@At(value="TAIL")})
    private void runTail(DataWriter writer, CallbackInfoReturnable<CompletableFuture<?>> cir) {
        fabricDataOutputThreadLocal.remove();
        blockStateMapThreadLocal.remove();
    }

    @Inject(method={"method_25738"}, at={@At(value="HEAD")}, cancellable=true)
    private static void filterBlocksForProcessingMod(Map<Block, BlockStateSupplier> map, Block block, CallbackInfoReturnable<Boolean> cir) {
        FabricDataOutput dataOutput = fabricDataOutputThreadLocal.get();
        if (dataOutput != null) {
            if (!dataOutput.isStrictValidationEnabled()) {
                cir.setReturnValue((Object)false);
                return;
            }
            if (!Registries.BLOCK.getId((Object)block).getNamespace().equals(dataOutput.getModId())) {
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Inject(method={"method_25741"}, at={@At(value="INVOKE", target="Lnet/minecraft/data/client/ModelIds;getItemModelId(Lnet/minecraft/item/Item;)Lnet/minecraft/util/Identifier;")}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD)
    private static void filterItemsForProcessingMod(Set<Item> set, Map<Identifier, Supplier<JsonElement>> map, Block block, CallbackInfo ci, Item item) {
        FabricDataOutput dataOutput = fabricDataOutputThreadLocal.get();
        if (dataOutput != null) {
            if (!blockStateMapThreadLocal.get().containsKey(block)) {
                ci.cancel();
                return;
            }
            if (!Registries.ITEM.getId((Object)item).getNamespace().equals(dataOutput.getModId())) {
                ci.cancel();
            }
        }
    }
}

