/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.datagen.v1.provider;

import com.google.common.base.Preconditions;
import java.util.function.BiConsumer;
import net.fabricmc.fabric.api.resource.conditions.v1.ConditionJsonProvider;
import net.fabricmc.fabric.impl.datagen.FabricDataGenHelper;
import net.minecraft.data.DataProvider;
import net.minecraft.data.server.loottable.LootTableGenerator;
import net.minecraft.loot.LootTable;
import net.minecraft.util.Identifier;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.NonExtendable
public interface FabricLootTableProvider
extends LootTableGenerator,
DataProvider {
    default public BiConsumer<Identifier, LootTable.Builder> withConditions(BiConsumer<Identifier, LootTable.Builder> exporter, ConditionJsonProvider ... conditions) {
        Preconditions.checkArgument((conditions.length > 0 ? 1 : 0) != 0, (Object)"Must add at least one condition.");
        return (id, table) -> {
            FabricDataGenHelper.addConditions(table, conditions);
            exporter.accept((Identifier)id, (LootTable.Builder)table);
        };
    }
}

