/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.datagen.v1.provider;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.event.registry.DynamicRegistries;
import net.fabricmc.fabric.impl.registry.sync.DynamicRegistriesImpl;
import net.minecraft.data.DataOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.DataWriter;
import net.minecraft.registry.Registry;
import net.minecraft.registry.RegistryEntryLookup;
import net.minecraft.registry.RegistryKey;
import net.minecraft.registry.RegistryKeys;
import net.minecraft.registry.RegistryLoader;
import net.minecraft.registry.RegistryOps;
import net.minecraft.registry.RegistryWrapper;
import net.minecraft.registry.entry.RegistryEntry;
import net.minecraft.registry.entry.RegistryEntryOwner;
import net.minecraft.util.Identifier;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.feature.PlacedFeature;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FabricDynamicRegistryProvider
implements DataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(FabricDynamicRegistryProvider.class);
    private final FabricDataOutput output;
    private final CompletableFuture<RegistryWrapper.WrapperLookup> registriesFuture;

    public FabricDynamicRegistryProvider(FabricDataOutput output, CompletableFuture<RegistryWrapper.WrapperLookup> registriesFuture) {
        this.output = output;
        this.registriesFuture = registriesFuture;
    }

    protected abstract void configure(RegistryWrapper.WrapperLookup var1, Entries var2);

    public CompletableFuture<?> run(DataWriter writer) {
        return this.registriesFuture.thenCompose(registries -> CompletableFuture.supplyAsync(() -> {
            Entries entries = new Entries((RegistryWrapper.WrapperLookup)registries, this.output.getModId());
            this.configure((RegistryWrapper.WrapperLookup)registries, entries);
            return entries;
        }).thenCompose(entries -> {
            RegistryOps dynamicOps = RegistryOps.of((DynamicOps)JsonOps.INSTANCE, (RegistryWrapper.WrapperLookup)registries);
            ArrayList futures = new ArrayList();
            for (RegistryEntries<?> registryEntries : entries.queuedEntries.values()) {
                futures.add(this.writeRegistryEntries(writer, (RegistryOps<JsonElement>)dynamicOps, registryEntries));
            }
            return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
        }));
    }

    private <T> CompletableFuture<?> writeRegistryEntries(DataWriter writer, RegistryOps<JsonElement> ops, RegistryEntries<T> entries) {
        RegistryKey registry = entries.registry;
        boolean shouldOmitNamespace = registry.getValue().getNamespace().equals("minecraft") || !DynamicRegistriesImpl.FABRIC_DYNAMIC_REGISTRY_KEYS.contains(registry);
        String directoryName = shouldOmitNamespace ? registry.getValue().getPath() : registry.getValue().getNamespace() + "/" + registry.getValue().getPath();
        DataOutput.PathResolver pathResolver = this.output.getResolver(DataOutput.OutputType.DATA_PACK, directoryName);
        ArrayList futures = new ArrayList();
        for (Map.Entry entry : entries.entries.entrySet()) {
            Path path = pathResolver.resolveJson(entry.getKey().getValue());
            futures.add(FabricDynamicRegistryProvider.writeToPath(path, writer, ops, entries.elementCodec, entry.getValue()));
        }
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    private static <E> CompletableFuture<?> writeToPath(Path path, DataWriter cache, DynamicOps<JsonElement> json, Encoder<E> encoder, E value) {
        Optional optional = encoder.encodeStart(json, value).resultOrPartial(error -> LOGGER.error("Couldn't serialize element {}: {}", (Object)path, error));
        if (optional.isPresent()) {
            return DataProvider.writeToPath((DataWriter)cache, (JsonElement)((JsonElement)optional.get()), (Path)path);
        }
        return CompletableFuture.completedFuture(null);
    }

    private static class RegistryEntries<T> {
        final RegistryEntryOwner<T> lookup;
        final RegistryKey<? extends Registry<T>> registry;
        final Codec<T> elementCodec;
        Map<RegistryKey<T>, T> entries = new IdentityHashMap<RegistryKey<T>, T>();

        RegistryEntries(RegistryEntryOwner<T> lookup, RegistryKey<? extends Registry<T>> registry, Codec<T> elementCodec) {
            this.lookup = lookup;
            this.registry = registry;
            this.elementCodec = elementCodec;
        }

        static <T> RegistryEntries<T> create(RegistryWrapper.WrapperLookup lookups, RegistryLoader.Entry<T> loaderEntry) {
            RegistryWrapper.Impl lookup = lookups.getWrapperOrThrow(loaderEntry.key());
            return new RegistryEntries<T>(lookup, loaderEntry.key(), loaderEntry.elementCodec());
        }

        public RegistryEntry<T> add(RegistryKey<T> key, T value) {
            if (this.entries.put(key, value) != null) {
                throw new IllegalArgumentException("Trying to add registry key " + String.valueOf(key) + " more than once.");
            }
            return RegistryEntry.Reference.standAlone(this.lookup, key);
        }

        public RegistryEntry<T> add(Identifier id, T value) {
            return this.add(RegistryKey.of(this.registry, (Identifier)id), value);
        }
    }

    public static final class Entries {
        private final RegistryWrapper.WrapperLookup registries;
        private final Map<Identifier, RegistryEntries<?>> queuedEntries;
        private final String modId;

        @ApiStatus.Internal
        Entries(RegistryWrapper.WrapperLookup registries, String modId) {
            this.registries = registries;
            this.queuedEntries = DynamicRegistries.getDynamicRegistries().stream().filter(e -> registries.getOptionalWrapper(e.key()).isPresent()).collect(Collectors.toMap(e -> e.key().getValue(), e -> RegistryEntries.create(registries, e)));
            this.modId = modId;
        }

        public RegistryWrapper.WrapperLookup getLookups() {
            return this.registries;
        }

        public <T> RegistryEntryLookup<T> getLookup(RegistryKey<? extends Registry<T>> registryKey) {
            return this.registries.getWrapperOrThrow(registryKey);
        }

        public RegistryEntryLookup<PlacedFeature> placedFeatures() {
            return this.getLookup(RegistryKeys.PLACED_FEATURE);
        }

        public RegistryEntryLookup<ConfiguredCarver<?>> configuredCarvers() {
            return this.getLookup(RegistryKeys.CONFIGURED_CARVER);
        }

        public <T> RegistryEntry<T> ref(RegistryKey<T> key) {
            RegistryEntries<T> entries = this.getQueuedEntries(key);
            return RegistryEntry.Reference.standAlone(entries.lookup, key);
        }

        public <T> RegistryEntry<T> add(RegistryKey<T> registry, T object) {
            return this.getQueuedEntries(registry).add(registry.getValue(), object);
        }

        public <T> RegistryEntry<T> add(RegistryWrapper.Impl<T> registry, RegistryKey<T> valueKey) {
            return this.add(valueKey, registry.getOrThrow(valueKey).value());
        }

        public <T> List<RegistryEntry<T>> addAll(RegistryWrapper.Impl<T> registry) {
            return registry.streamKeys().filter(registryKey -> registryKey.getValue().getNamespace().equals(this.modId)).map(key -> this.add(registry, (RegistryKey)key)).toList();
        }

        <T> RegistryEntries<T> getQueuedEntries(RegistryKey<T> key) {
            RegistryEntries<?> regEntries = this.queuedEntries.get(key.getRegistry());
            if (regEntries == null) {
                throw new IllegalArgumentException("Registry " + String.valueOf(key.getRegistry()) + " is not loaded from datapacks");
            }
            return regEntries;
        }
    }
}

