/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.gamerule.widget;

import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.gamerule.v1.rule.DoubleRule;
import net.fabricmc.fabric.mixin.gamerule.client.EditGameRulesScreenAccessor;
import net.minecraft.client.MinecraftClient;
import net.minecraft.client.gui.DrawContext;
import net.minecraft.client.gui.screen.world.EditGameRulesScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.text.OrderedText;
import net.minecraft.text.Text;

@Environment(value=EnvType.CLIENT)
public final class DoubleRuleWidget
extends EditGameRulesScreen.NamedRuleWidget {
    private final TextFieldWidget textFieldWidget;

    public DoubleRuleWidget(EditGameRulesScreen gameRuleScreen, Text name, List<OrderedText> description, String ruleName, DoubleRule rule) {
        EditGameRulesScreen editGameRulesScreen = gameRuleScreen;
        Objects.requireNonNull(editGameRulesScreen);
        super(editGameRulesScreen, description, name);
        EditGameRulesScreenAccessor accessor = (EditGameRulesScreenAccessor)gameRuleScreen;
        this.textFieldWidget = new TextFieldWidget(MinecraftClient.getInstance().textRenderer, 10, 5, 42, 20, (Text)name.copy().append("\n").append(ruleName).append("\n"));
        this.textFieldWidget.setText(Double.toString(rule.get()));
        this.textFieldWidget.setChangedListener(value -> {
            if (rule.validate((String)value)) {
                this.textFieldWidget.setEditableColor(0xE0E0E0);
                accessor.callMarkValid((EditGameRulesScreen.AbstractRuleWidget)this);
            } else {
                this.textFieldWidget.setEditableColor(0xFF0000);
                accessor.callMarkInvalid((EditGameRulesScreen.AbstractRuleWidget)this);
            }
        });
        this.children.add(this.textFieldWidget);
    }

    public void render(DrawContext drawContext, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        this.drawName(drawContext, y, x);
        this.textFieldWidget.setPosition(x + entryWidth - 44, y);
        this.textFieldWidget.render(drawContext, mouseX, mouseY, tickDelta);
    }
}

