/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.client.message.v1;

import com.mojang.authlib.GameProfile;
import java.time.Instant;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.network.message.MessageType;
import net.minecraft.network.message.SignedMessage;
import net.minecraft.text.Text;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class ClientReceiveMessageEvents {
    public static final Event<AllowChat> ALLOW_CHAT = EventFactory.createArrayBacked(AllowChat.class, listeners -> (message, signedMessage, sender, params, receptionTimestamp) -> {
        for (AllowChat listener : listeners) {
            if (listener.allowReceiveChatMessage(message, signedMessage, sender, params, receptionTimestamp)) continue;
            return false;
        }
        return true;
    });
    public static final Event<AllowGame> ALLOW_GAME = EventFactory.createArrayBacked(AllowGame.class, listeners -> (message, overlay) -> {
        for (AllowGame listener : listeners) {
            if (listener.allowReceiveGameMessage(message, overlay)) continue;
            return false;
        }
        return true;
    });
    public static final Event<ModifyGame> MODIFY_GAME = EventFactory.createArrayBacked(ModifyGame.class, listeners -> (message, overlay) -> {
        for (ModifyGame listener : listeners) {
            message = listener.modifyReceivedGameMessage(message, overlay);
        }
        return message;
    });
    public static final Event<Chat> CHAT = EventFactory.createArrayBacked(Chat.class, listeners -> (message, signedMessage, sender, params, receptionTimestamp) -> {
        for (Chat listener : listeners) {
            listener.onReceiveChatMessage(message, signedMessage, sender, params, receptionTimestamp);
        }
    });
    public static final Event<Game> GAME = EventFactory.createArrayBacked(Game.class, listeners -> (message, overlay) -> {
        for (Game listener : listeners) {
            listener.onReceiveGameMessage(message, overlay);
        }
    });
    public static final Event<ChatCanceled> CHAT_CANCELED = EventFactory.createArrayBacked(ChatCanceled.class, listeners -> (message, signedMessage, sender, params, receptionTimestamp) -> {
        for (ChatCanceled listener : listeners) {
            listener.onReceiveChatMessageCanceled(message, signedMessage, sender, params, receptionTimestamp);
        }
    });
    public static final Event<GameCanceled> GAME_CANCELED = EventFactory.createArrayBacked(GameCanceled.class, listeners -> (message, overlay) -> {
        for (GameCanceled listener : listeners) {
            listener.onReceiveGameMessageCanceled(message, overlay);
        }
    });

    private ClientReceiveMessageEvents() {
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface GameCanceled {
        public void onReceiveGameMessageCanceled(Text var1, boolean var2);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface ChatCanceled {
        public void onReceiveChatMessageCanceled(Text var1, @Nullable SignedMessage var2, @Nullable GameProfile var3, MessageType.Parameters var4, Instant var5);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface Game {
        public void onReceiveGameMessage(Text var1, boolean var2);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface Chat {
        public void onReceiveChatMessage(Text var1, @Nullable SignedMessage var2, @Nullable GameProfile var3, MessageType.Parameters var4, Instant var5);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface ModifyGame {
        public Text modifyReceivedGameMessage(Text var1, boolean var2);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface AllowGame {
        public boolean allowReceiveGameMessage(Text var1, boolean var2);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface AllowChat {
        public boolean allowReceiveChatMessage(Text var1, @Nullable SignedMessage var2, @Nullable GameProfile var3, MessageType.Parameters var4, Instant var5);
    }
}

