/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer.render;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.api.util.TriState;
import net.fabricmc.fabric.impl.client.indigo.Indigo;
import net.fabricmc.fabric.impl.client.indigo.renderer.aocalc.AoCalculator;
import net.fabricmc.fabric.impl.client.indigo.renderer.aocalc.AoConfig;
import net.fabricmc.fabric.impl.client.indigo.renderer.helper.ColorHelper;
import net.fabricmc.fabric.impl.client.indigo.renderer.material.RenderMaterialImpl;
import net.fabricmc.fabric.impl.client.indigo.renderer.mesh.EncodingFormat;
import net.fabricmc.fabric.impl.client.indigo.renderer.mesh.MutableQuadViewImpl;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.AbstractRenderContext;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.BlockRenderInfo;
import net.fabricmc.fabric.impl.renderer.VanillaModelEncoder;
import net.minecraft.block.BlockState;
import net.minecraft.client.render.RenderLayer;
import net.minecraft.client.render.VertexConsumer;
import net.minecraft.client.render.WorldRenderer;
import net.minecraft.client.render.model.BakedModel;
import net.minecraft.client.render.model.json.ModelTransformationMode;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Direction;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.BlockRenderView;
import net.minecraft.world.BlockView;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public abstract class AbstractBlockRenderContext
extends AbstractRenderContext {
    protected final BlockRenderInfo blockInfo = new BlockRenderInfo();
    protected final AoCalculator aoCalc;
    private final MutableQuadViewImpl editorQuad = new MutableQuadViewImpl(){
        {
            this.data = new int[EncodingFormat.TOTAL_STRIDE];
            this.clear();
        }

        @Override
        public void emitDirectly() {
            AbstractBlockRenderContext.this.renderQuad(this, false);
        }
    };
    private final MutableQuadViewImpl vanillaModelEditorQuad = new MutableQuadViewImpl(){
        {
            this.data = new int[EncodingFormat.TOTAL_STRIDE];
            this.clear();
        }

        @Override
        public void emitDirectly() {
            AbstractBlockRenderContext.this.renderQuad(this, true);
        }
    };
    private final BakedModelConsumerImpl vanillaModelConsumer = new BakedModelConsumerImpl();
    private final BlockPos.Mutable lightPos = new BlockPos.Mutable();

    protected AbstractBlockRenderContext() {
        this.aoCalc = this.createAoCalc(this.blockInfo);
    }

    protected abstract AoCalculator createAoCalc(BlockRenderInfo var1);

    protected abstract VertexConsumer getVertexConsumer(RenderLayer var1);

    public QuadEmitter getEmitter() {
        this.editorQuad.clear();
        return this.editorQuad;
    }

    public QuadEmitter getVanillaModelEmitter() {
        return this.vanillaModelEditorQuad;
    }

    public boolean isFaceCulled(@Nullable Direction face) {
        return !this.blockInfo.shouldDrawFace(face);
    }

    public ModelTransformationMode itemTransformationMode() {
        throw new IllegalStateException("itemTransformationMode() can only be called on an item render context.");
    }

    public RenderContext.BakedModelConsumer bakedModelConsumer() {
        return this.vanillaModelConsumer;
    }

    private void renderQuad(MutableQuadViewImpl quad, boolean isVanilla) {
        if (!this.transform((MutableQuadView)quad)) {
            return;
        }
        if (this.isFaceCulled(quad.cullFace())) {
            return;
        }
        RenderMaterialImpl mat = quad.material();
        int colorIndex = mat.disableColorIndex() ? -1 : quad.colorIndex();
        TriState aoMode = mat.ambientOcclusion();
        boolean ao = this.blockInfo.useAo && (aoMode == TriState.TRUE || aoMode == TriState.DEFAULT && this.blockInfo.defaultAo);
        boolean emissive = mat.emissive();
        VertexConsumer vertexConsumer = this.getVertexConsumer(this.blockInfo.effectiveRenderLayer(mat.blendMode()));
        this.colorizeQuad(quad, colorIndex);
        this.shadeQuad(quad, isVanilla, ao, emissive);
        this.bufferQuad(quad, vertexConsumer);
    }

    private void colorizeQuad(MutableQuadViewImpl quad, int colorIndex) {
        if (colorIndex != -1) {
            int blockColor = this.blockInfo.blockColor(colorIndex);
            for (int i = 0; i < 4; ++i) {
                quad.color(i, ColorHelper.multiplyColor(blockColor, quad.color(i)));
            }
        }
    }

    private void shadeQuad(MutableQuadViewImpl quad, boolean isVanilla, boolean ao, boolean emissive) {
        if (ao) {
            this.aoCalc.compute(quad, isVanilla);
            if (emissive) {
                for (int i = 0; i < 4; ++i) {
                    quad.color(i, ColorHelper.multiplyRGB(quad.color(i), this.aoCalc.ao[i]));
                    quad.lightmap(i, 0xF000F0);
                }
            } else {
                for (int i = 0; i < 4; ++i) {
                    quad.color(i, ColorHelper.multiplyRGB(quad.color(i), this.aoCalc.ao[i]));
                    quad.lightmap(i, ColorHelper.maxBrightness(quad.lightmap(i), this.aoCalc.light[i]));
                }
            }
        } else {
            this.shadeFlatQuad(quad, isVanilla);
            if (emissive) {
                for (int i = 0; i < 4; ++i) {
                    quad.lightmap(i, 0xF000F0);
                }
            } else {
                int brightness = this.flatBrightness(quad, this.blockInfo.blockState, this.blockInfo.blockPos);
                for (int i = 0; i < 4; ++i) {
                    quad.lightmap(i, ColorHelper.maxBrightness(quad.lightmap(i), brightness));
                }
            }
        }
    }

    private void shadeFlatQuad(MutableQuadViewImpl quad, boolean isVanilla) {
        block9: {
            boolean hasShade;
            block7: {
                float faceShade;
                block10: {
                    block8: {
                        hasShade = quad.hasShade();
                        if ((Indigo.AMBIENT_OCCLUSION_MODE != AoConfig.HYBRID || isVanilla) && Indigo.AMBIENT_OCCLUSION_MODE != AoConfig.ENHANCED) break block7;
                        if (!quad.hasAllVertexNormals()) break block8;
                        for (int i = 0; i < 4; ++i) {
                            float shade = this.normalShade(quad.normalX(i), quad.normalY(i), quad.normalZ(i), hasShade);
                            quad.color(i, ColorHelper.multiplyRGB(quad.color(i), shade));
                        }
                        break block9;
                    }
                    if ((quad.geometryFlags() & 2) != 0) {
                        faceShade = this.blockInfo.blockView.getBrightness(quad.lightFace(), hasShade);
                    } else {
                        Vector3f faceNormal = quad.faceNormal();
                        faceShade = this.normalShade(faceNormal.x, faceNormal.y, faceNormal.z, hasShade);
                    }
                    if (!quad.hasVertexNormals()) break block10;
                    for (int i = 0; i < 4; ++i) {
                        float shade = quad.hasNormal(i) ? this.normalShade(quad.normalX(i), quad.normalY(i), quad.normalZ(i), hasShade) : faceShade;
                        quad.color(i, ColorHelper.multiplyRGB(quad.color(i), shade));
                    }
                    break block9;
                }
                if (faceShade == 1.0f) break block9;
                for (int i = 0; i < 4; ++i) {
                    quad.color(i, ColorHelper.multiplyRGB(quad.color(i), faceShade));
                }
                break block9;
            }
            float faceShade = this.blockInfo.blockView.getBrightness(quad.lightFace(), hasShade);
            if (faceShade != 1.0f) {
                for (int i = 0; i < 4; ++i) {
                    quad.color(i, ColorHelper.multiplyRGB(quad.color(i), faceShade));
                }
            }
        }
    }

    private float normalShade(float normalX, float normalY, float normalZ, boolean hasShade) {
        float sum = 0.0f;
        float div = 0.0f;
        if (normalX > 0.0f) {
            sum += normalX * this.blockInfo.blockView.getBrightness(Direction.EAST, hasShade);
            div += normalX;
        } else if (normalX < 0.0f) {
            sum += -normalX * this.blockInfo.blockView.getBrightness(Direction.WEST, hasShade);
            div -= normalX;
        }
        if (normalY > 0.0f) {
            sum += normalY * this.blockInfo.blockView.getBrightness(Direction.UP, hasShade);
            div += normalY;
        } else if (normalY < 0.0f) {
            sum += -normalY * this.blockInfo.blockView.getBrightness(Direction.DOWN, hasShade);
            div -= normalY;
        }
        if (normalZ > 0.0f) {
            sum += normalZ * this.blockInfo.blockView.getBrightness(Direction.SOUTH, hasShade);
            div += normalZ;
        } else if (normalZ < 0.0f) {
            sum += -normalZ * this.blockInfo.blockView.getBrightness(Direction.NORTH, hasShade);
            div -= normalZ;
        }
        return sum / div;
    }

    private int flatBrightness(MutableQuadViewImpl quad, BlockState blockState, BlockPos pos) {
        this.lightPos.set((Vec3i)pos);
        if (quad.cullFace() != null) {
            this.lightPos.move(quad.cullFace());
        } else {
            int flags = quad.geometryFlags();
            if ((flags & 4) != 0 || (flags & 2) != 0 && blockState.isFullCube((BlockView)this.blockInfo.blockView, pos)) {
                this.lightPos.move(quad.lightFace());
            }
        }
        return WorldRenderer.getLightmapCoordinates((BlockRenderView)this.blockInfo.blockView, (BlockState)blockState, (BlockPos)this.lightPos);
    }

    @Environment(value=EnvType.CLIENT)
    private class BakedModelConsumerImpl
    implements RenderContext.BakedModelConsumer {
        private BakedModelConsumerImpl() {
        }

        public void accept(BakedModel model) {
            this.accept(model, AbstractBlockRenderContext.this.blockInfo.blockState);
        }

        public void accept(BakedModel model, @Nullable BlockState state) {
            VanillaModelEncoder.emitBlockQuads((BakedModel)model, (BlockState)state, AbstractBlockRenderContext.this.blockInfo.randomSupplier, (RenderContext)AbstractBlockRenderContext.this, (QuadEmitter)AbstractBlockRenderContext.this.vanillaModelEditorQuad);
        }
    }
}

