/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer.aocalc;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.impl.client.indigo.renderer.aocalc.AoVertexClampFunction;
import net.fabricmc.fabric.impl.client.indigo.renderer.mesh.QuadViewImpl;
import net.minecraft.util.Util;
import net.minecraft.util.math.Direction;

@Environment(value=EnvType.CLIENT)
enum AoFace {
    AOF_DOWN(new Direction[]{Direction.WEST, Direction.EAST, Direction.NORTH, Direction.SOUTH}, (q, i) -> AoVertexClampFunction.CLAMP_FUNC.clamp(q.y(i)), (q, i, w) -> {
        float u = AoVertexClampFunction.CLAMP_FUNC.clamp(q.x(i));
        float v = AoVertexClampFunction.CLAMP_FUNC.clamp(q.z(i));
        w[0] = (1.0f - u) * v;
        w[1] = (1.0f - u) * (1.0f - v);
        w[2] = u * (1.0f - v);
        w[3] = u * v;
    }),
    AOF_UP(new Direction[]{Direction.EAST, Direction.WEST, Direction.NORTH, Direction.SOUTH}, (q, i) -> 1.0f - AoVertexClampFunction.CLAMP_FUNC.clamp(q.y(i)), (q, i, w) -> {
        float u = AoVertexClampFunction.CLAMP_FUNC.clamp(q.x(i));
        float v = AoVertexClampFunction.CLAMP_FUNC.clamp(q.z(i));
        w[0] = u * v;
        w[1] = u * (1.0f - v);
        w[2] = (1.0f - u) * (1.0f - v);
        w[3] = (1.0f - u) * v;
    }),
    AOF_NORTH(new Direction[]{Direction.UP, Direction.DOWN, Direction.EAST, Direction.WEST}, (q, i) -> AoVertexClampFunction.CLAMP_FUNC.clamp(q.z(i)), (q, i, w) -> {
        float u = AoVertexClampFunction.CLAMP_FUNC.clamp(q.y(i));
        float v = AoVertexClampFunction.CLAMP_FUNC.clamp(q.x(i));
        w[0] = u * (1.0f - v);
        w[1] = u * v;
        w[2] = (1.0f - u) * v;
        w[3] = (1.0f - u) * (1.0f - v);
    }),
    AOF_SOUTH(new Direction[]{Direction.WEST, Direction.EAST, Direction.DOWN, Direction.UP}, (q, i) -> 1.0f - AoVertexClampFunction.CLAMP_FUNC.clamp(q.z(i)), (q, i, w) -> {
        float u = AoVertexClampFunction.CLAMP_FUNC.clamp(q.y(i));
        float v = AoVertexClampFunction.CLAMP_FUNC.clamp(q.x(i));
        w[0] = u * (1.0f - v);
        w[1] = (1.0f - u) * (1.0f - v);
        w[2] = (1.0f - u) * v;
        w[3] = u * v;
    }),
    AOF_WEST(new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH, Direction.SOUTH}, (q, i) -> AoVertexClampFunction.CLAMP_FUNC.clamp(q.x(i)), (q, i, w) -> {
        float u = AoVertexClampFunction.CLAMP_FUNC.clamp(q.y(i));
        float v = AoVertexClampFunction.CLAMP_FUNC.clamp(q.z(i));
        w[0] = u * v;
        w[1] = u * (1.0f - v);
        w[2] = (1.0f - u) * (1.0f - v);
        w[3] = (1.0f - u) * v;
    }),
    AOF_EAST(new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH}, (q, i) -> 1.0f - AoVertexClampFunction.CLAMP_FUNC.clamp(q.x(i)), (q, i, w) -> {
        float u = AoVertexClampFunction.CLAMP_FUNC.clamp(q.y(i));
        float v = AoVertexClampFunction.CLAMP_FUNC.clamp(q.z(i));
        w[0] = (1.0f - u) * v;
        w[1] = (1.0f - u) * (1.0f - v);
        w[2] = u * (1.0f - v);
        w[3] = u * v;
    });

    final Direction[] neighbors;
    final WeightFunction weightFunc;
    final Vertex2Float depthFunc;
    private static final AoFace[] values;

    private AoFace(Direction[] faces, Vertex2Float depthFunc, WeightFunction weightFunc) {
        this.neighbors = faces;
        this.depthFunc = depthFunc;
        this.weightFunc = weightFunc;
    }

    public static AoFace get(Direction direction) {
        return values[direction.getId()];
    }

    static {
        values = (AoFace[])Util.make((Object)new AoFace[6], neighborData -> {
            neighborData[Direction.DOWN.getId()] = AOF_DOWN;
            neighborData[Direction.UP.getId()] = AOF_UP;
            neighborData[Direction.NORTH.getId()] = AOF_NORTH;
            neighborData[Direction.SOUTH.getId()] = AOF_SOUTH;
            neighborData[Direction.WEST.getId()] = AOF_WEST;
            neighborData[Direction.EAST.getId()] = AOF_EAST;
        });
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    static interface Vertex2Float {
        public float apply(QuadViewImpl var1, int var2);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    static interface WeightFunction {
        public void apply(QuadViewImpl var1, int var2, float[] var3);
    }
}

