/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.registry;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.fabric.impl.content.registry.util.ImmutableCollectionUtils;
import net.fabricmc.fabric.mixin.content.registry.FarmerWorkTaskAccessor;
import net.fabricmc.fabric.mixin.content.registry.GiveGiftsToHeroTaskAccessor;
import net.fabricmc.fabric.mixin.content.registry.VillagerEntityAccessor;
import net.minecraft.entity.passive.VillagerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemConvertible;
import net.minecraft.util.Identifier;
import net.minecraft.village.VillagerProfession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VillagerInteractionRegistries {
    private static final Logger LOGGER = LoggerFactory.getLogger(VillagerInteractionRegistries.class);

    private VillagerInteractionRegistries() {
    }

    public static void registerCollectable(ItemConvertible item) {
        Objects.requireNonNull(item.asItem(), "Item cannot be null!");
        VillagerInteractionRegistries.getCollectableRegistry().add(item.asItem());
    }

    public static void registerCompostable(ItemConvertible item) {
        Objects.requireNonNull(item.asItem(), "Item cannot be null!");
        VillagerInteractionRegistries.getCompostableRegistry().add(item.asItem());
    }

    public static void registerFood(ItemConvertible item, int foodValue) {
        Objects.requireNonNull(item.asItem(), "Item cannot be null!");
        Integer oldValue = VillagerInteractionRegistries.getFoodRegistry().put(item.asItem(), foodValue);
        if (oldValue != null) {
            LOGGER.info("Overriding previous food value of {}, was: {}, now: {}", new Object[]{item.asItem().toString(), oldValue, foodValue});
        }
    }

    public static void registerGiftLootTable(VillagerProfession profession, Identifier lootTable) {
        Objects.requireNonNull(profession, "Profession cannot be null!");
        Objects.requireNonNull(lootTable, "Loot table identifier cannot be null!");
        Identifier oldValue = GiveGiftsToHeroTaskAccessor.fabric_getGifts().put(profession, lootTable);
        if (oldValue != null) {
            LOGGER.info("Overriding previous gift loot table of {} profession, was: {}, now: {}", new Object[]{profession.id(), oldValue, lootTable});
        }
    }

    private static Set<Item> getCollectableRegistry() {
        return ImmutableCollectionUtils.getAsMutableSet(VillagerEntityAccessor::fabric_getGatherableItems, VillagerEntityAccessor::fabric_setGatherableItems);
    }

    private static List<Item> getCompostableRegistry() {
        return ImmutableCollectionUtils.getAsMutableList(FarmerWorkTaskAccessor::fabric_getCompostable, FarmerWorkTaskAccessor::fabric_setCompostables);
    }

    private static Map<Item, Integer> getFoodRegistry() {
        return ImmutableCollectionUtils.getAsMutableMap(() -> VillagerEntity.ITEM_FOOD_VALUES, VillagerEntityAccessor::fabric_setItemFoodValues);
    }
}

