/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.registry;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.ai.pathing.PathNodeType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.BlockView;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LandPathNodeTypesRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(LandPathNodeTypesRegistry.class);
    private static final Map<Block, PathNodeTypeProvider> NODE_TYPES = new IdentityHashMap<Block, PathNodeTypeProvider>();

    private LandPathNodeTypesRegistry() {
    }

    public static void register(Block block, @Nullable PathNodeType nodeType, @Nullable PathNodeType nodeTypeIfNeighbor) {
        Objects.requireNonNull(block, "Block cannot be null!");
        LandPathNodeTypesRegistry.register(block, (state, neighbor) -> neighbor ? nodeTypeIfNeighbor : nodeType);
    }

    public static void register(Block block, StaticPathNodeTypeProvider provider) {
        Objects.requireNonNull(block, "Block cannot be null!");
        Objects.requireNonNull(provider, "StaticPathNodeTypeProvider cannot be null!");
        PathNodeTypeProvider old = NODE_TYPES.put(block, provider);
        if (old != null) {
            LOGGER.debug("Replaced PathNodeType provider for the block {}", (Object)block);
        }
    }

    public static void registerDynamic(Block block, DynamicPathNodeTypeProvider provider) {
        Objects.requireNonNull(block, "Block cannot be null!");
        Objects.requireNonNull(provider, "DynamicPathNodeTypeProvider cannot be null!");
        PathNodeTypeProvider old = NODE_TYPES.put(block, provider);
        if (old != null) {
            LOGGER.debug("Replaced PathNodeType provider for the block {}", (Object)block);
        }
    }

    @Nullable
    public static PathNodeType getPathNodeType(BlockState state, BlockView world, BlockPos pos, boolean neighbor) {
        Objects.requireNonNull(state, "BlockState cannot be null!");
        Objects.requireNonNull(world, "BlockView cannot be null!");
        Objects.requireNonNull(pos, "BlockPos cannot be null!");
        PathNodeTypeProvider provider = LandPathNodeTypesRegistry.getPathNodeTypeProvider(state.getBlock());
        if (provider == null) {
            return null;
        }
        if (provider instanceof DynamicPathNodeTypeProvider) {
            return ((DynamicPathNodeTypeProvider)provider).getPathNodeType(state, world, pos, neighbor);
        }
        return ((StaticPathNodeTypeProvider)provider).getPathNodeType(state, neighbor);
    }

    @Nullable
    public static PathNodeTypeProvider getPathNodeTypeProvider(Block block) {
        Objects.requireNonNull(block, "Block cannot be null!");
        return NODE_TYPES.get(block);
    }

    @FunctionalInterface
    public static interface StaticPathNodeTypeProvider
    extends PathNodeTypeProvider {
        @Nullable
        public PathNodeType getPathNodeType(BlockState var1, boolean var2);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface PathNodeTypeProvider {
    }

    @FunctionalInterface
    public static interface DynamicPathNodeTypeProvider
    extends PathNodeTypeProvider {
        @Nullable
        public PathNodeType getPathNodeType(BlockState var1, BlockView var2, BlockPos var3, boolean var4);
    }
}

