/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.registry;

import net.fabricmc.fabric.api.util.Block2ObjectMap;
import net.fabricmc.fabric.impl.content.registry.FlammableBlockRegistryImpl;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.registry.tag.TagKey;

public interface FlammableBlockRegistry
extends Block2ObjectMap<Entry> {
    public static FlammableBlockRegistry getDefaultInstance() {
        return FlammableBlockRegistry.getInstance(Blocks.FIRE);
    }

    public static FlammableBlockRegistry getInstance(Block block) {
        return FlammableBlockRegistryImpl.getInstance(block);
    }

    default public void add(Block block, int burn, int spread) {
        this.add(block, new Entry(burn, spread));
    }

    default public void add(TagKey<Block> tag, int burn, int spread) {
        this.add(tag, new Entry(burn, spread));
    }

    public static final class Entry {
        private final int burn;
        private final int spread;

        public Entry(int burn, int spread) {
            this.burn = burn;
            this.spread = spread;
        }

        public int getBurnChance() {
            return this.burn;
        }

        public int getSpreadChance() {
            return this.spread;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)o;
            return other.burn == this.burn && other.spread == this.spread;
        }

        public int hashCode() {
            return this.burn * 11 + this.spread;
        }
    }
}

