/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.resource.conditions;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.fabricmc.fabric.impl.resource.conditions.ResourceConditionsImpl;
import net.minecraft.loot.LootDataType;
import net.minecraft.loot.LootManager;
import net.minecraft.registry.DynamicRegistryManager;
import net.minecraft.resource.ResourceManager;
import net.minecraft.util.Identifier;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={LootManager.class})
public class LootManagerMixin {
    @Unique
    private static final Map<Object, DynamicRegistryManager.Immutable> dynamicRegistryManagerMap = Collections.synchronizedMap(new IdentityHashMap());

    @Inject(method={"load"}, at={@At(value="INVOKE", target="Ljava/util/concurrent/CompletableFuture;runAsync(Ljava/lang/Runnable;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private static void load(LootDataType type, ResourceManager resourceManager, Executor executor, Map<LootDataType<?>, Map<Identifier, ?>> results, CallbackInfoReturnable<CompletableFuture<?>> cir, Map map) {
        dynamicRegistryManagerMap.put(map, ResourceConditionsImpl.CURRENT_REGISTRIES.get());
    }

    @Inject(method={"method_51189"}, at={@At(value="HEAD")})
    private static void runAsync(ResourceManager resourceManager, LootDataType lootDataType, Map map, CallbackInfo ci) {
        assert (ResourceConditionsImpl.CURRENT_REGISTRIES.get() == null);
        ResourceConditionsImpl.CURRENT_REGISTRIES.set(Objects.requireNonNull(dynamicRegistryManagerMap.remove(map)));
    }

    @Inject(method={"method_51195"}, at={@At(value="HEAD")}, cancellable=true)
    private static void applyResourceConditions(LootDataType lootDataType, Map map, Identifier id, JsonElement json, CallbackInfo ci) {
        JsonObject obj;
        if (json.isJsonObject() && (obj = json.getAsJsonObject()).has("fabric:load_conditions")) {
            boolean matched = ResourceConditions.objectMatchesConditions(obj);
            if (!matched) {
                ci.cancel();
            }
            if (ResourceConditionsImpl.LOGGER.isDebugEnabled()) {
                String verdict = matched ? "Allowed" : "Rejected";
                ResourceConditionsImpl.LOGGER.debug("{} resource of type {} with id {}", new Object[]{verdict, lootDataType.getId(), id});
            }
        }
    }

    @Inject(method={"method_51189"}, at={@At(value="RETURN")})
    private static void runAsyncEnd(ResourceManager resourceManager, LootDataType lootDataType, Map map, CallbackInfo ci) {
        ResourceConditionsImpl.CURRENT_REGISTRIES.remove();
    }
}

