/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.resource.conditions.v1;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.function.Function;
import net.fabricmc.fabric.api.resource.conditions.v1.ConditionJsonProvider;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.fabricmc.fabric.impl.resource.conditions.ResourceConditionsImpl;
import net.minecraft.block.Block;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemConvertible;
import net.minecraft.registry.Registries;
import net.minecraft.registry.Registry;
import net.minecraft.registry.RegistryKey;
import net.minecraft.registry.RegistryKeys;
import net.minecraft.registry.tag.TagKey;
import net.minecraft.resource.featuretoggle.FeatureFlag;
import net.minecraft.util.Identifier;
import net.minecraft.util.JsonHelper;

public final class DefaultResourceConditions {
    private static final Identifier NOT = new Identifier("fabric:not");
    private static final Identifier AND = new Identifier("fabric:and");
    private static final Identifier OR = new Identifier("fabric:or");
    private static final Identifier ALL_MODS_LOADED = new Identifier("fabric:all_mods_loaded");
    private static final Identifier ANY_MOD_LOADED = new Identifier("fabric:any_mod_loaded");
    private static final Identifier BLOCK_TAGS_POPULATED = new Identifier("fabric:block_tags_populated");
    private static final Identifier FLUID_TAGS_POPULATED = new Identifier("fabric:fluid_tags_populated");
    private static final Identifier ITEM_TAGS_POPULATED = new Identifier("fabric:item_tags_populated");
    private static final Identifier TAGS_POPULATED = new Identifier("fabric:tags_populated");
    private static final Identifier FEATURES_ENABLED = new Identifier("fabric:features_enabled");
    private static final Identifier REGISTRY_CONTAINS = new Identifier("fabric:registry_contains");

    public static ConditionJsonProvider not(final ConditionJsonProvider value) {
        return new ConditionJsonProvider(){

            @Override
            public void writeParameters(JsonObject object) {
                object.add("value", (JsonElement)value.toJson());
            }

            @Override
            public Identifier getConditionId() {
                return NOT;
            }
        };
    }

    public static ConditionJsonProvider and(ConditionJsonProvider ... values) {
        return ResourceConditionsImpl.array(AND, values);
    }

    public static ConditionJsonProvider or(ConditionJsonProvider ... values) {
        return ResourceConditionsImpl.array(OR, values);
    }

    public static ConditionJsonProvider allModsLoaded(String ... modIds) {
        return ResourceConditionsImpl.mods(ALL_MODS_LOADED, modIds);
    }

    public static ConditionJsonProvider anyModLoaded(String ... modIds) {
        return ResourceConditionsImpl.mods(ANY_MOD_LOADED, modIds);
    }

    @SafeVarargs
    @Deprecated
    public static ConditionJsonProvider blockTagsPopulated(TagKey<Block> ... tags) {
        return ResourceConditionsImpl.tagsPopulated(BLOCK_TAGS_POPULATED, false, tags);
    }

    @SafeVarargs
    @Deprecated
    public static ConditionJsonProvider fluidTagsPopulated(TagKey<Fluid> ... tags) {
        return ResourceConditionsImpl.tagsPopulated(FLUID_TAGS_POPULATED, false, tags);
    }

    @SafeVarargs
    @Deprecated
    public static ConditionJsonProvider itemTagsPopulated(TagKey<Item> ... tags) {
        return ResourceConditionsImpl.tagsPopulated(ITEM_TAGS_POPULATED, false, tags);
    }

    @SafeVarargs
    public static <T> ConditionJsonProvider tagsPopulated(TagKey<T> ... tags) {
        return ResourceConditionsImpl.tagsPopulated(TAGS_POPULATED, true, tags);
    }

    public static ConditionJsonProvider featuresEnabled(FeatureFlag ... features) {
        return ResourceConditionsImpl.featuresEnabled(FEATURES_ENABLED, features);
    }

    public static ConditionJsonProvider itemsRegistered(ItemConvertible ... items) {
        return DefaultResourceConditions.registryContains(Registries.ITEM, DefaultResourceConditions.transform(items, ItemConvertible::asItem, new Item[0]));
    }

    @SafeVarargs
    public static <T> ConditionJsonProvider registryContains(Registry<T> registry, T ... entries) {
        return DefaultResourceConditions.registryContains(DefaultResourceConditions.transform(entries, e -> (RegistryKey)registry.getKey(e).orElseThrow(() -> new IllegalArgumentException("Entry is not registered")), new RegistryKey[0]));
    }

    @SafeVarargs
    public static <T> ConditionJsonProvider registryContains(RegistryKey<T> ... entries) {
        Preconditions.checkArgument((entries.length > 0 ? 1 : 0) != 0, (Object)"Must register at least one entry.");
        return DefaultResourceConditions.registryContains(RegistryKey.ofRegistry((Identifier)entries[0].getRegistry()), DefaultResourceConditions.transform(entries, RegistryKey::getValue, new Identifier[0]));
    }

    public static <T> ConditionJsonProvider registryContains(RegistryKey<Registry<T>> registry, Identifier ... entries) {
        return ResourceConditionsImpl.registryContains(REGISTRY_CONTAINS, registry.getValue(), entries);
    }

    static void init() {
    }

    @SafeVarargs
    private static <A, B> B[] transform(A[] input, Function<A, B> mapper, B ... outputType) {
        B[] output = Arrays.copyOf(outputType, input.length);
        for (int i = 0; i < input.length; ++i) {
            output[i] = mapper.apply(input[i]);
        }
        return output;
    }

    private DefaultResourceConditions() {
    }

    static {
        ResourceConditions.register(NOT, object -> {
            JsonObject condition = JsonHelper.getObject((JsonObject)object, (String)"value");
            return !ResourceConditions.conditionMatches(condition);
        });
        ResourceConditions.register(AND, object -> {
            JsonArray array = JsonHelper.getArray((JsonObject)object, (String)"values");
            return ResourceConditions.conditionsMatch(array, true);
        });
        ResourceConditions.register(OR, object -> {
            JsonArray array = JsonHelper.getArray((JsonObject)object, (String)"values");
            return ResourceConditions.conditionsMatch(array, false);
        });
        ResourceConditions.register(ALL_MODS_LOADED, object -> ResourceConditionsImpl.modsLoadedMatch(object, true));
        ResourceConditions.register(ANY_MOD_LOADED, object -> ResourceConditionsImpl.modsLoadedMatch(object, false));
        ResourceConditions.register(BLOCK_TAGS_POPULATED, object -> ResourceConditionsImpl.tagsPopulatedMatch(object, RegistryKeys.BLOCK));
        ResourceConditions.register(FLUID_TAGS_POPULATED, object -> ResourceConditionsImpl.tagsPopulatedMatch(object, RegistryKeys.FLUID));
        ResourceConditions.register(ITEM_TAGS_POPULATED, object -> ResourceConditionsImpl.tagsPopulatedMatch(object, RegistryKeys.ITEM));
        ResourceConditions.register(TAGS_POPULATED, ResourceConditionsImpl::tagsPopulatedMatch);
        ResourceConditions.register(FEATURES_ENABLED, ResourceConditionsImpl::featuresEnabledMatch);
        ResourceConditions.register(REGISTRY_CONTAINS, ResourceConditionsImpl::registryContainsMatch);
    }
}

