/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.object.builder.v1.block;

import java.util.function.Function;
import java.util.function.ToIntFunction;
import net.fabricmc.fabric.mixin.object.builder.AbstractBlockAccessor;
import net.fabricmc.fabric.mixin.object.builder.AbstractBlockSettingsAccessor;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.MapColor;
import net.minecraft.block.enums.Instrument;
import net.minecraft.block.piston.PistonBehavior;
import net.minecraft.entity.EntityType;
import net.minecraft.resource.featuretoggle.FeatureFlag;
import net.minecraft.sound.BlockSoundGroup;
import net.minecraft.util.DyeColor;
import net.minecraft.util.Identifier;

public class FabricBlockSettings
extends AbstractBlock.Settings {
    protected FabricBlockSettings() {
    }

    protected FabricBlockSettings(AbstractBlock.Settings settings) {
        this();
        AbstractBlockSettingsAccessor thisAccessor = (AbstractBlockSettingsAccessor)((Object)this);
        AbstractBlockSettingsAccessor otherAccessor = (AbstractBlockSettingsAccessor)settings;
        this.hardness(otherAccessor.getHardness());
        this.resistance(otherAccessor.getResistance());
        this.collidable(otherAccessor.getCollidable());
        thisAccessor.setRandomTicks(otherAccessor.getRandomTicks());
        this.luminance((ToIntFunction)otherAccessor.getLuminance());
        thisAccessor.setMapColorProvider(otherAccessor.getMapColorProvider());
        this.sounds(otherAccessor.getSoundGroup());
        this.slipperiness(otherAccessor.getSlipperiness());
        this.velocityMultiplier(otherAccessor.getVelocityMultiplier());
        thisAccessor.setDynamicBounds(otherAccessor.getDynamicBounds());
        thisAccessor.setOpaque(otherAccessor.getOpaque());
        thisAccessor.setIsAir(otherAccessor.getIsAir());
        thisAccessor.setBurnable(otherAccessor.getBurnable());
        thisAccessor.setLiquid(otherAccessor.getLiquid());
        thisAccessor.setForceNotSolid(otherAccessor.getForceNotSolid());
        thisAccessor.setForceSolid(otherAccessor.getForceSolid());
        this.pistonBehavior(otherAccessor.getPistonBehavior());
        thisAccessor.setToolRequired(otherAccessor.isToolRequired());
        thisAccessor.setOffsetter(otherAccessor.getOffsetter());
        thisAccessor.setBlockBreakParticles(otherAccessor.getBlockBreakParticles());
        thisAccessor.setRequiredFeatures(otherAccessor.getRequiredFeatures());
        this.emissiveLighting(otherAccessor.getEmissiveLightingPredicate());
        this.instrument(otherAccessor.getInstrument());
        thisAccessor.setReplaceable(otherAccessor.getReplaceable());
        this.jumpVelocityMultiplier(otherAccessor.getJumpVelocityMultiplier());
        this.drops(otherAccessor.getLootTableId());
        this.allowsSpawning((AbstractBlock.TypedContextPredicate)otherAccessor.getAllowsSpawningPredicate());
        this.solidBlock(otherAccessor.getSolidBlockPredicate());
        this.suffocates(otherAccessor.getSuffocationPredicate());
        this.blockVision(otherAccessor.getBlockVisionPredicate());
        this.postProcess(otherAccessor.getPostProcessPredicate());
    }

    public static FabricBlockSettings create() {
        return new FabricBlockSettings();
    }

    @Deprecated
    public static FabricBlockSettings of() {
        return FabricBlockSettings.create();
    }

    public static FabricBlockSettings copyOf(AbstractBlock block) {
        return new FabricBlockSettings(((AbstractBlockAccessor)block).getSettings());
    }

    public static FabricBlockSettings copyOf(AbstractBlock.Settings settings) {
        return new FabricBlockSettings(settings);
    }

    public FabricBlockSettings noCollision() {
        super.noCollision();
        return this;
    }

    public FabricBlockSettings nonOpaque() {
        super.nonOpaque();
        return this;
    }

    public FabricBlockSettings slipperiness(float value) {
        super.slipperiness(value);
        return this;
    }

    public FabricBlockSettings velocityMultiplier(float velocityMultiplier) {
        super.velocityMultiplier(velocityMultiplier);
        return this;
    }

    public FabricBlockSettings jumpVelocityMultiplier(float jumpVelocityMultiplier) {
        super.jumpVelocityMultiplier(jumpVelocityMultiplier);
        return this;
    }

    public FabricBlockSettings sounds(BlockSoundGroup group) {
        super.sounds(group);
        return this;
    }

    @Deprecated
    public FabricBlockSettings lightLevel(ToIntFunction<BlockState> levelFunction) {
        return this.luminance((ToIntFunction)levelFunction);
    }

    public FabricBlockSettings luminance(ToIntFunction<BlockState> luminanceFunction) {
        super.luminance(luminanceFunction);
        return this;
    }

    public FabricBlockSettings strength(float hardness, float resistance) {
        super.strength(hardness, resistance);
        return this;
    }

    public FabricBlockSettings breakInstantly() {
        super.breakInstantly();
        return this;
    }

    public FabricBlockSettings strength(float strength) {
        super.strength(strength);
        return this;
    }

    public FabricBlockSettings ticksRandomly() {
        super.ticksRandomly();
        return this;
    }

    public FabricBlockSettings dynamicBounds() {
        super.dynamicBounds();
        return this;
    }

    public FabricBlockSettings dropsNothing() {
        super.dropsNothing();
        return this;
    }

    public FabricBlockSettings dropsLike(Block block) {
        super.dropsLike(block);
        return this;
    }

    public FabricBlockSettings air() {
        super.air();
        return this;
    }

    public FabricBlockSettings allowsSpawning(AbstractBlock.TypedContextPredicate<EntityType<?>> predicate) {
        super.allowsSpawning(predicate);
        return this;
    }

    public FabricBlockSettings solidBlock(AbstractBlock.ContextPredicate predicate) {
        super.solidBlock(predicate);
        return this;
    }

    public FabricBlockSettings suffocates(AbstractBlock.ContextPredicate predicate) {
        super.suffocates(predicate);
        return this;
    }

    public FabricBlockSettings blockVision(AbstractBlock.ContextPredicate predicate) {
        super.blockVision(predicate);
        return this;
    }

    public FabricBlockSettings postProcess(AbstractBlock.ContextPredicate predicate) {
        super.postProcess(predicate);
        return this;
    }

    public FabricBlockSettings emissiveLighting(AbstractBlock.ContextPredicate predicate) {
        super.emissiveLighting(predicate);
        return this;
    }

    public FabricBlockSettings requiresTool() {
        super.requiresTool();
        return this;
    }

    public FabricBlockSettings mapColor(MapColor color) {
        super.mapColor(color);
        return this;
    }

    public FabricBlockSettings hardness(float hardness) {
        super.hardness(hardness);
        return this;
    }

    public FabricBlockSettings resistance(float resistance) {
        super.resistance(resistance);
        return this;
    }

    public FabricBlockSettings offset(AbstractBlock.OffsetType offsetType) {
        super.offset(offsetType);
        return this;
    }

    public FabricBlockSettings noBlockBreakParticles() {
        super.noBlockBreakParticles();
        return this;
    }

    public FabricBlockSettings requires(FeatureFlag ... features) {
        super.requires(features);
        return this;
    }

    public FabricBlockSettings mapColor(Function<BlockState, MapColor> mapColorProvider) {
        super.mapColor(mapColorProvider);
        return this;
    }

    public FabricBlockSettings burnable() {
        super.burnable();
        return this;
    }

    public FabricBlockSettings liquid() {
        super.liquid();
        return this;
    }

    public FabricBlockSettings solid() {
        super.solid();
        return this;
    }

    public FabricBlockSettings notSolid() {
        super.notSolid();
        return this;
    }

    public FabricBlockSettings pistonBehavior(PistonBehavior pistonBehavior) {
        super.pistonBehavior(pistonBehavior);
        return this;
    }

    public FabricBlockSettings instrument(Instrument instrument) {
        super.instrument(instrument);
        return this;
    }

    public FabricBlockSettings replaceable() {
        super.replaceable();
        return this;
    }

    @Deprecated
    public FabricBlockSettings lightLevel(int lightLevel) {
        this.luminance(lightLevel);
        return this;
    }

    public FabricBlockSettings luminance(int luminance) {
        this.luminance(ignored -> luminance);
        return this;
    }

    public FabricBlockSettings drops(Identifier dropTableId) {
        ((AbstractBlockSettingsAccessor)((Object)this)).setLootTableId(dropTableId);
        return this;
    }

    @Deprecated
    public FabricBlockSettings materialColor(MapColor color) {
        return this.mapColor(color);
    }

    @Deprecated
    public FabricBlockSettings materialColor(DyeColor color) {
        return this.mapColor(color);
    }

    public FabricBlockSettings mapColor(DyeColor color) {
        return this.mapColor(color.getMapColor());
    }

    public FabricBlockSettings collidable(boolean collidable) {
        ((AbstractBlockSettingsAccessor)((Object)this)).setCollidable(collidable);
        return this;
    }
}

