/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.keybinding;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.mixin.client.keybinding.KeyBindingAccessor;
import net.minecraft.client.MinecraftClient;
import net.minecraft.client.option.KeyBinding;

@Environment(value=EnvType.CLIENT)
public final class KeyBindingRegistryImpl {
    private static final List<KeyBinding> MODDED_KEY_BINDINGS = new ReferenceArrayList();

    private KeyBindingRegistryImpl() {
    }

    private static Map<String, Integer> getCategoryMap() {
        return KeyBindingAccessor.fabric_getCategoryMap();
    }

    public static boolean addCategory(String categoryTranslationKey) {
        Map<String, Integer> map = KeyBindingRegistryImpl.getCategoryMap();
        if (map.containsKey(categoryTranslationKey)) {
            return false;
        }
        Optional<Integer> largest = map.values().stream().max(Integer::compareTo);
        int largestInt = largest.orElse(0);
        map.put(categoryTranslationKey, largestInt + 1);
        return true;
    }

    public static KeyBinding registerKeyBinding(KeyBinding binding) {
        if (MinecraftClient.getInstance().options != null) {
            throw new IllegalStateException("GameOptions has already been initialised");
        }
        for (KeyBinding existingKeyBindings : MODDED_KEY_BINDINGS) {
            if (existingKeyBindings == binding) {
                throw new IllegalArgumentException("Attempted to register a key binding twice: " + binding.getTranslationKey());
            }
            if (!existingKeyBindings.getTranslationKey().equals(binding.getTranslationKey())) continue;
            throw new IllegalArgumentException("Attempted to register two key bindings with equal ID: " + binding.getTranslationKey() + "!");
        }
        KeyBindingRegistryImpl.addCategory(binding.getCategory());
        MODDED_KEY_BINDINGS.add(binding);
        return binding;
    }

    public static KeyBinding[] process(KeyBinding[] keysAll) {
        ArrayList newKeysAll = Lists.newArrayList((Object[])keysAll);
        newKeysAll.removeAll(MODDED_KEY_BINDINGS);
        newKeysAll.addAll(MODDED_KEY_BINDINGS);
        return newKeysAll.toArray(new KeyBinding[0]);
    }
}

