/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.gametest;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.DataFixer;
import java.io.IOException;
import java.io.Reader;
import java.util.Optional;
import java.util.stream.Stream;
import net.fabricmc.fabric.impl.gametest.FabricGameTestHelper;
import net.minecraft.block.Block;
import net.minecraft.nbt.NbtCompound;
import net.minecraft.nbt.NbtHelper;
import net.minecraft.registry.RegistryEntryLookup;
import net.minecraft.resource.Resource;
import net.minecraft.resource.ResourceFinder;
import net.minecraft.resource.ResourceManager;
import net.minecraft.structure.StructureTemplate;
import net.minecraft.structure.StructureTemplateManager;
import net.minecraft.util.Identifier;
import net.minecraft.world.level.storage.LevelStorage;
import org.apache.commons.io.IOUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={StructureTemplateManager.class})
public abstract class StructureTemplateManagerMixin {
    @Shadow
    private ResourceManager field_25189;

    @Shadow
    public abstract StructureTemplate method_21891(NbtCompound var1);

    private Optional<StructureTemplate> fabric_loadSnbtFromResource(Identifier id) {
        Identifier path = FabricGameTestHelper.GAMETEST_STRUCTURE_FINDER.toResourcePath(id);
        Optional resource = this.field_25189.getResource(path);
        if (resource.isPresent()) {
            try {
                String snbt = IOUtils.toString((Reader)((Resource)resource.get()).getReader());
                NbtCompound nbt = NbtHelper.fromNbtProviderString((String)snbt);
                return Optional.of(this.method_21891(nbt));
            }
            catch (CommandSyntaxException | IOException e) {
                throw new RuntimeException("Failed to load GameTest structure " + String.valueOf(id), e);
            }
        }
        return Optional.empty();
    }

    private Stream<Identifier> fabric_streamTemplatesFromResource() {
        ResourceFinder finder = FabricGameTestHelper.GAMETEST_STRUCTURE_FINDER;
        return finder.findResources(this.field_25189).keySet().stream().map(arg_0 -> ((ResourceFinder)finder).toResourceId(arg_0));
    }

    @Inject(method={"<init>"}, at={@At(value="INVOKE", target="Lcom/google/common/collect/ImmutableList$Builder;add(Ljava/lang/Object;)Lcom/google/common/collect/ImmutableList$Builder;", ordinal=2, shift=At.Shift.AFTER, remap=false)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void addFabricTemplateProvider(ResourceManager resourceManager, LevelStorage.Session session, DataFixer dataFixer, RegistryEntryLookup<Block> blockLookup, CallbackInfo ci, ImmutableList.Builder<StructureTemplateManager.Provider> builder) {
        builder.add((Object)new StructureTemplateManager.Provider(this::fabric_loadSnbtFromResource, this::fabric_streamTemplatesFromResource));
    }
}

