/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.gametest;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.function.Consumer;
import javax.xml.parsers.ParserConfigurationException;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.gametest.v1.FabricGameTest;
import net.fabricmc.fabric.impl.gametest.FabricGameTestModInitializer;
import net.fabricmc.fabric.impl.gametest.SavingXmlReportingTestCompletionListener;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.resource.ResourceFinder;
import net.minecraft.resource.ResourcePackManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.test.GameTestBatch;
import net.minecraft.test.TestCompletionListener;
import net.minecraft.test.TestContext;
import net.minecraft.test.TestFailureLogger;
import net.minecraft.test.TestFunction;
import net.minecraft.test.TestFunctions;
import net.minecraft.test.TestServer;
import net.minecraft.test.TestUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.level.storage.LevelStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FabricGameTestHelper {
    public static final boolean ENABLED = System.getProperty("fabric-api.gametest") != null;
    public static final boolean COMMAND_ENABLED = Boolean.parseBoolean(System.getProperty("fabric-api.gametest.command", FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT ? "true" : "false"));
    private static final Logger LOGGER = LoggerFactory.getLogger(FabricGameTestHelper.class);
    private static final String GAMETEST_STRUCTURE_PATH = "gametest/structures";
    public static final ResourceFinder GAMETEST_STRUCTURE_FINDER = new ResourceFinder("gametest/structures", ".snbt");

    private FabricGameTestHelper() {
    }

    public static void runHeadlessServer(LevelStorage.Session session, ResourcePackManager resourcePackManager) {
        String reportPath = System.getProperty("fabric-api.gametest.report-file");
        if (reportPath != null) {
            try {
                TestFailureLogger.setCompletionListener((TestCompletionListener)new SavingXmlReportingTestCompletionListener(new File(reportPath)));
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
        LOGGER.info("Starting test server");
        MinecraftServer server = TestServer.startServer(thread -> TestServer.create((Thread)thread, (LevelStorage.Session)session, (ResourcePackManager)resourcePackManager, FabricGameTestHelper.getBatches(), (BlockPos)BlockPos.ORIGIN));
    }

    public static Consumer<TestContext> getTestMethodInvoker(Method method) {
        return testContext -> {
            Object testObject;
            Constructor<?> constructor;
            Class<?> testClass = method.getDeclaringClass();
            try {
                constructor = testClass.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Test class (%s) provided by (%s) must have a public default or no args constructor".formatted(testClass.getSimpleName(), FabricGameTestModInitializer.getModIdForTestClass(testClass)));
            }
            try {
                testObject = constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException("Failed to create instance of test class (%s)".formatted(testClass.getCanonicalName()), e);
            }
            if (testObject instanceof FabricGameTest) {
                FabricGameTest fabricGameTest = (FabricGameTest)testObject;
                fabricGameTest.invokeTestMethod((TestContext)testContext, method);
            } else {
                FabricGameTestHelper.invokeTestMethod(testContext, method, testObject);
            }
        };
    }

    public static void invokeTestMethod(TestContext testContext, Method method, Object testObject) {
        try {
            method.invoke(testObject, testContext);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to invoke test method (%s) in (%s) because %s".formatted(method.getName(), method.getDeclaringClass().getCanonicalName(), e.getMessage()), e);
        }
        catch (InvocationTargetException e) {
            LOGGER.error("Exception occurred when invoking test method {} in ({})", new Object[]{method.getName(), method.getDeclaringClass().getCanonicalName(), e});
            Throwable throwable = e.getCause();
            if (throwable instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)throwable;
                throw runtimeException;
            }
            throw new RuntimeException(e.getCause());
        }
    }

    private static Collection<GameTestBatch> getBatches() {
        return TestUtil.createBatches(FabricGameTestHelper.getTestFunctions());
    }

    private static Collection<TestFunction> getTestFunctions() {
        return TestFunctions.getTestFunctions();
    }
}

