/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.blockrenderlayer;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.minecraft.block.Block;
import net.minecraft.client.render.RenderLayer;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;

@Environment(value=EnvType.CLIENT)
public class BlockRenderLayerMapImpl
implements BlockRenderLayerMap {
    private static Map<Block, RenderLayer> blockRenderLayerMap = new HashMap<Block, RenderLayer>();
    private static Map<Item, RenderLayer> itemRenderLayerMap = new HashMap<Item, RenderLayer>();
    private static Map<Fluid, RenderLayer> fluidRenderLayerMap = new HashMap<Fluid, RenderLayer>();
    private static BiConsumer<Block, RenderLayer> blockHandler = (b, l) -> blockRenderLayerMap.put((Block)b, (RenderLayer)l);
    private static BiConsumer<Item, RenderLayer> itemHandler = (i, l) -> itemRenderLayerMap.put((Item)i, (RenderLayer)l);
    private static BiConsumer<Fluid, RenderLayer> fluidHandler = (f, b) -> fluidRenderLayerMap.put((Fluid)f, (RenderLayer)b);

    @Override
    public void putBlock(Block block, RenderLayer renderLayer) {
        if (block == null) {
            throw new IllegalArgumentException("Request to map null block to BlockRenderLayer");
        }
        if (renderLayer == null) {
            throw new IllegalArgumentException("Request to map block " + block.toString() + " to null BlockRenderLayer");
        }
        blockHandler.accept(block, renderLayer);
    }

    @Override
    public void putBlocks(RenderLayer renderLayer, Block ... blocks) {
        for (Block block : blocks) {
            this.putBlock(block, renderLayer);
        }
    }

    @Override
    public void putItem(Item item, RenderLayer renderLayer) {
        if (item == null) {
            throw new IllegalArgumentException("Request to map null item to BlockRenderLayer");
        }
        if (renderLayer == null) {
            throw new IllegalArgumentException("Request to map item " + item.toString() + " to null BlockRenderLayer");
        }
        itemHandler.accept(item, renderLayer);
    }

    @Override
    public void putItems(RenderLayer renderLayer, Item ... items) {
        for (Item item : items) {
            this.putItem(item, renderLayer);
        }
    }

    @Override
    public void putFluid(Fluid fluid, RenderLayer renderLayer) {
        if (fluid == null) {
            throw new IllegalArgumentException("Request to map null fluid to BlockRenderLayer");
        }
        if (renderLayer == null) {
            throw new IllegalArgumentException("Request to map fluid " + fluid.toString() + " to null BlockRenderLayer");
        }
        fluidHandler.accept(fluid, renderLayer);
    }

    @Override
    public void putFluids(RenderLayer renderLayer, Fluid ... fluids) {
        for (Fluid fluid : fluids) {
            this.putFluid(fluid, renderLayer);
        }
    }

    public static void initialize(BiConsumer<Block, RenderLayer> blockHandlerIn, BiConsumer<Fluid, RenderLayer> fluidHandlerIn) {
        BiConsumer<Item, RenderLayer> itemHandlerIn = (item, renderLayer) -> blockHandlerIn.accept(Block.getBlockFromItem((Item)item), (RenderLayer)renderLayer);
        blockRenderLayerMap.forEach(blockHandlerIn);
        itemRenderLayerMap.forEach(itemHandlerIn);
        fluidRenderLayerMap.forEach(fluidHandlerIn);
        blockHandler = blockHandlerIn;
        itemHandler = itemHandlerIn;
        fluidHandler = fluidHandlerIn;
    }
}

