/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.loot;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.fabric.api.loot.v2.FabricLootTableBuilder;
import net.fabricmc.fabric.api.loot.v2.LootTableEvents;
import net.fabricmc.fabric.api.loot.v2.LootTableSource;
import net.fabricmc.fabric.impl.loot.LootUtil;
import net.minecraft.loot.LootDataKey;
import net.minecraft.loot.LootManager;
import net.minecraft.loot.LootTable;
import net.minecraft.resource.ResourceManager;
import net.minecraft.resource.ResourceReloader;
import net.minecraft.util.profiler.Profiler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LootManager.class})
abstract class LootManagerMixin {
    @Shadow
    private Map<LootDataKey<?>, ?> field_44492;

    LootManagerMixin() {
    }

    @Inject(method={"reload"}, at={@At(value="RETURN")}, cancellable=true)
    private void reload(ResourceReloader.Synchronizer synchronizer, ResourceManager manager, Profiler prepareProfiler, Profiler applyProfiler, Executor prepareExecutor, Executor applyExecutor, CallbackInfoReturnable<CompletableFuture<Void>> cir) {
        LootManager lootManager = (LootManager)this;
        cir.setReturnValue((Object)((CompletableFuture)cir.getReturnValue()).thenRun(() -> this.applyLootTableEvents(manager, lootManager)));
    }

    @Unique
    private void applyLootTableEvents(ResourceManager resourceManager, LootManager lootManager) {
        ImmutableMap.Builder newTables = ImmutableMap.builder();
        this.field_44492.forEach((dataKey, entry) -> {
            if (dataKey == LootManager.EMPTY_LOOT_TABLE) {
                newTables.put(dataKey, entry);
                return;
            }
            if (!(entry instanceof LootTable)) {
                newTables.put(dataKey, entry);
                return;
            }
            LootTable table = (LootTable)entry;
            LootTableSource source = LootUtil.determineSource(dataKey.id(), resourceManager);
            LootTable replacement = ((LootTableEvents.Replace)LootTableEvents.REPLACE.invoker()).replaceLootTable(resourceManager, lootManager, dataKey.id(), table, source);
            if (replacement != null) {
                table = replacement;
                source = LootTableSource.REPLACED;
            }
            LootTable.Builder builder = FabricLootTableBuilder.copyOf(table);
            ((LootTableEvents.Modify)LootTableEvents.MODIFY.invoker()).modifyLootTable(resourceManager, lootManager, dataKey.id(), builder, source);
            newTables.put(dataKey, (Object)builder.build());
        });
        this.field_44492 = newTables.build();
        ((LootTableEvents.Loaded)LootTableEvents.ALL_LOADED.invoker()).onLootTablesLoaded(resourceManager, lootManager);
    }
}

