/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.loot.v2;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.fabricmc.fabric.api.loot.v2.LootTableSource;
import net.minecraft.loot.LootManager;
import net.minecraft.loot.LootTable;
import net.minecraft.resource.ResourceManager;
import net.minecraft.util.Identifier;
import org.jetbrains.annotations.Nullable;

public final class LootTableEvents {
    public static final Event<Replace> REPLACE = EventFactory.createArrayBacked(Replace.class, listeners -> (resourceManager, lootManager, id, original, source) -> {
        for (Replace listener : listeners) {
            @Nullable LootTable replaced = listener.replaceLootTable(resourceManager, lootManager, id, original, source);
            if (replaced == null) continue;
            return replaced;
        }
        return null;
    });
    public static final Event<Modify> MODIFY = EventFactory.createArrayBacked(Modify.class, listeners -> (resourceManager, lootManager, id, tableBuilder, source) -> {
        for (Modify listener : listeners) {
            listener.modifyLootTable(resourceManager, lootManager, id, tableBuilder, source);
        }
    });
    public static final Event<Loaded> ALL_LOADED = EventFactory.createArrayBacked(Loaded.class, listeners -> (resourceManager, lootManager) -> {
        for (Loaded listener : listeners) {
            listener.onLootTablesLoaded(resourceManager, lootManager);
        }
    });

    private LootTableEvents() {
    }

    public static interface Loaded {
        public void onLootTablesLoaded(ResourceManager var1, LootManager var2);
    }

    public static interface Modify {
        public void modifyLootTable(ResourceManager var1, LootManager var2, Identifier var3, LootTable.Builder var4, LootTableSource var5);
    }

    public static interface Replace {
        @Nullable
        public LootTable replaceLootTable(ResourceManager var1, LootManager var2, Identifier var3, LootTable var4, LootTableSource var5);
    }
}

