/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.loot.v2;

import java.util.Collection;
import java.util.List;
import net.fabricmc.fabric.mixin.loot.LootPoolAccessor;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.condition.LootCondition;
import net.minecraft.loot.entry.LootPoolEntry;
import net.minecraft.loot.function.LootFunction;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.NonExtendable
public interface FabricLootPoolBuilder {
    default public LootPool.Builder with(LootPoolEntry entry) {
        throw new UnsupportedOperationException("Implemented via mixin");
    }

    default public LootPool.Builder with(Collection<? extends LootPoolEntry> entries) {
        throw new UnsupportedOperationException("Implemented via mixin");
    }

    default public LootPool.Builder conditionally(LootCondition condition) {
        throw new UnsupportedOperationException("Implemented via mixin");
    }

    default public LootPool.Builder conditionally(Collection<? extends LootCondition> conditions) {
        throw new UnsupportedOperationException("Implemented via mixin");
    }

    default public LootPool.Builder apply(LootFunction function) {
        throw new UnsupportedOperationException("Implemented via mixin");
    }

    default public LootPool.Builder apply(Collection<? extends LootFunction> functions) {
        throw new UnsupportedOperationException("Implemented via mixin");
    }

    public static LootPool.Builder copyOf(LootPool pool) {
        LootPoolAccessor accessor = (LootPoolAccessor)pool;
        return LootPool.builder().rolls(accessor.fabric_getRolls()).bonusRolls(accessor.fabric_getBonusRolls()).with(List.of(accessor.fabric_getEntries())).conditionally(List.of(accessor.fabric_getConditions())).apply(List.of(accessor.fabric_getFunctions()));
    }
}

