/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.client.networking.v1;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.impl.networking.client.ClientNetworkingImpl;
import net.minecraft.client.MinecraftClient;
import net.minecraft.client.network.ClientLoginNetworkHandler;
import net.minecraft.network.ClientConnection;
import net.minecraft.network.PacketByteBuf;
import net.minecraft.network.listener.PacketListener;
import net.minecraft.util.Identifier;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class ClientLoginNetworking {
    public static boolean registerGlobalReceiver(Identifier channelName, LoginQueryRequestHandler queryHandler) {
        return ClientNetworkingImpl.LOGIN.registerGlobalReceiver(channelName, (Object)queryHandler);
    }

    @Nullable
    public static LoginQueryRequestHandler unregisterGlobalReceiver(Identifier channelName) {
        return (LoginQueryRequestHandler)ClientNetworkingImpl.LOGIN.unregisterGlobalReceiver(channelName);
    }

    public static Set<Identifier> getGlobalReceivers() {
        return ClientNetworkingImpl.LOGIN.getChannels();
    }

    public static boolean registerReceiver(Identifier channelName, LoginQueryRequestHandler queryHandler) throws IllegalStateException {
        PacketListener packetListener;
        ClientConnection connection = ClientNetworkingImpl.getLoginConnection();
        if (connection != null && (packetListener = connection.getPacketListener()) instanceof ClientLoginNetworkHandler) {
            return ClientNetworkingImpl.getAddon((ClientLoginNetworkHandler)packetListener).registerChannel(channelName, queryHandler);
        }
        throw new IllegalStateException("Cannot register receiver while client is not logging in!");
    }

    @Nullable
    public static LoginQueryRequestHandler unregisterReceiver(Identifier channelName) throws IllegalStateException {
        PacketListener packetListener;
        ClientConnection connection = ClientNetworkingImpl.getLoginConnection();
        if (connection != null && (packetListener = connection.getPacketListener()) instanceof ClientLoginNetworkHandler) {
            return (LoginQueryRequestHandler)ClientNetworkingImpl.getAddon((ClientLoginNetworkHandler)packetListener).unregisterChannel(channelName);
        }
        throw new IllegalStateException("Cannot unregister receiver while client is not logging in!");
    }

    private ClientLoginNetworking() {
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface LoginQueryRequestHandler {
        public CompletableFuture<@Nullable PacketByteBuf> receive(MinecraftClient var1, ClientLoginNetworkHandler var2, PacketByteBuf var3, Consumer<GenericFutureListener<? extends Future<? super Void>>> var4);
    }
}

