/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.networking.client;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.impl.networking.NetworkHandlerExtensions;
import net.fabricmc.fabric.impl.networking.client.ClientNetworkingImpl;
import net.fabricmc.fabric.impl.networking.client.ClientPlayNetworkAddon;
import net.minecraft.client.MinecraftClient;
import net.minecraft.client.network.ClientPlayNetworkHandler;
import net.minecraft.network.packet.s2c.play.CustomPayloadS2CPacket;
import net.minecraft.network.packet.s2c.play.GameJoinS2CPacket;
import net.minecraft.text.Text;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={ClientPlayNetworkHandler.class}, priority=999)
abstract class ClientPlayNetworkHandlerMixin
implements NetworkHandlerExtensions {
    @Final
    @Shadow
    private MinecraftClient field_3690;
    @Unique
    private ClientPlayNetworkAddon addon;

    ClientPlayNetworkHandlerMixin() {
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void initAddon(CallbackInfo ci) {
        this.addon = new ClientPlayNetworkAddon((ClientPlayNetworkHandler)this, this.field_3690);
        ClientNetworkingImpl.setClientPlayAddon(this.addon);
        this.addon.lateInit();
    }

    @Inject(method={"onGameJoin"}, at={@At(value="RETURN")})
    private void handleServerPlayReady(GameJoinS2CPacket packet, CallbackInfo ci) {
        this.addon.onServerReady();
    }

    @Inject(method={"onCustomPayload"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleCustomPayload(CustomPayloadS2CPacket packet, CallbackInfo ci) {
        if (this.addon.handle(packet)) {
            ci.cancel();
        }
    }

    @Inject(method={"onDisconnected"}, at={@At(value="HEAD")})
    private void handleDisconnection(Text reason, CallbackInfo ci) {
        this.addon.handleDisconnect();
    }

    public ClientPlayNetworkAddon getAddon() {
        return this.addon;
    }
}

