/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.networking.client;

import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientLoginNetworking;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.impl.networking.ChannelInfoHolder;
import net.fabricmc.fabric.impl.networking.GlobalReceiverRegistry;
import net.fabricmc.fabric.impl.networking.NetworkHandlerExtensions;
import net.fabricmc.fabric.impl.networking.NetworkingImpl;
import net.fabricmc.fabric.impl.networking.client.ClientLoginNetworkAddon;
import net.fabricmc.fabric.impl.networking.client.ClientPlayNetworkAddon;
import net.fabricmc.fabric.mixin.networking.client.accessor.ClientLoginNetworkHandlerAccessor;
import net.fabricmc.fabric.mixin.networking.client.accessor.ConnectScreenAccessor;
import net.fabricmc.fabric.mixin.networking.client.accessor.MinecraftClientAccessor;
import net.minecraft.client.MinecraftClient;
import net.minecraft.client.gui.screen.ConnectScreen;
import net.minecraft.client.network.ClientLoginNetworkHandler;
import net.minecraft.client.network.ClientPlayNetworkHandler;
import net.minecraft.network.ClientConnection;
import net.minecraft.network.PacketByteBuf;
import net.minecraft.network.listener.ServerPlayPacketListener;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.c2s.play.CustomPayloadC2SPacket;
import net.minecraft.util.Identifier;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class ClientNetworkingImpl {
    public static final GlobalReceiverRegistry<ClientLoginNetworking.LoginQueryRequestHandler> LOGIN = new GlobalReceiverRegistry();
    public static final GlobalReceiverRegistry<ClientPlayNetworking.PlayChannelHandler> PLAY = new GlobalReceiverRegistry();
    private static ClientPlayNetworkAddon currentPlayAddon;

    public static ClientPlayNetworkAddon getAddon(ClientPlayNetworkHandler handler) {
        return (ClientPlayNetworkAddon)((NetworkHandlerExtensions)handler).getAddon();
    }

    public static ClientLoginNetworkAddon getAddon(ClientLoginNetworkHandler handler) {
        return (ClientLoginNetworkAddon)((NetworkHandlerExtensions)handler).getAddon();
    }

    public static Packet<ServerPlayPacketListener> createPlayC2SPacket(Identifier channelName, PacketByteBuf buf) {
        return new CustomPayloadC2SPacket(channelName, buf);
    }

    @Nullable
    public static ClientConnection getLoginConnection() {
        ClientConnection connection = ((MinecraftClientAccessor)MinecraftClient.getInstance()).getConnection();
        if (connection != null) {
            return connection;
        }
        if (MinecraftClient.getInstance().currentScreen instanceof ConnectScreen) {
            return ((ConnectScreenAccessor)MinecraftClient.getInstance().currentScreen).getConnection();
        }
        return null;
    }

    @Nullable
    public static ClientPlayNetworkAddon getClientPlayAddon() {
        if (MinecraftClient.getInstance().getNetworkHandler() != null) {
            currentPlayAddon = null;
            return ClientNetworkingImpl.getAddon(MinecraftClient.getInstance().getNetworkHandler());
        }
        if (currentPlayAddon != null) {
            return currentPlayAddon;
        }
        return null;
    }

    public static void setClientPlayAddon(ClientPlayNetworkAddon addon) {
        currentPlayAddon = addon;
    }

    public static void clientInit() {
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            currentPlayAddon = null;
        });
        ClientLoginNetworking.registerGlobalReceiver(NetworkingImpl.EARLY_REGISTRATION_CHANNEL, (client, handler, buf, listenerAdder) -> {
            int n = buf.readVarInt();
            ArrayList<Identifier> ids = new ArrayList<Identifier>(n);
            for (int i = 0; i < n; ++i) {
                ids.add(buf.readIdentifier());
            }
            ClientConnection connection = ((ClientLoginNetworkHandlerAccessor)handler).getConnection();
            ((ChannelInfoHolder)connection).getPendingChannelsNames().addAll(ids);
            NetworkingImpl.LOGGER.debug("Received accepted channels from the server");
            PacketByteBuf response = PacketByteBufs.create();
            Set<Identifier> channels = ClientPlayNetworking.getGlobalReceivers();
            response.writeVarInt(channels.size());
            for (Identifier id : channels) {
                response.writeIdentifier(id);
            }
            NetworkingImpl.LOGGER.debug("Sent accepted channels to the server");
            return CompletableFuture.completedFuture(response);
        });
    }
}

