/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.networking;

import io.netty.buffer.ByteBuf;
import io.netty.util.AsciiString;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.impl.networking.AbstractNetworkAddon;
import net.fabricmc.fabric.impl.networking.ChannelInfoHolder;
import net.fabricmc.fabric.impl.networking.GenericFutureListenerHolder;
import net.fabricmc.fabric.impl.networking.GlobalReceiverRegistry;
import net.fabricmc.fabric.impl.networking.NetworkingImpl;
import net.minecraft.network.ClientConnection;
import net.minecraft.network.PacketByteBuf;
import net.minecraft.network.PacketCallbacks;
import net.minecraft.network.packet.Packet;
import net.minecraft.util.Identifier;
import net.minecraft.util.InvalidIdentifierException;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractChanneledNetworkAddon<H>
extends AbstractNetworkAddon<H>
implements PacketSender {
    protected final ClientConnection connection;
    protected final GlobalReceiverRegistry<H> receiver;
    protected final Set<Identifier> sendableChannels;
    protected final Set<Identifier> sendableChannelsView;

    protected AbstractChanneledNetworkAddon(GlobalReceiverRegistry<H> receiver, ClientConnection connection, String description) {
        this(receiver, connection, new HashSet<Identifier>(), description);
    }

    protected AbstractChanneledNetworkAddon(GlobalReceiverRegistry<H> receiver, ClientConnection connection, Set<Identifier> sendableChannels, String description) {
        super(receiver, description);
        this.connection = connection;
        this.receiver = receiver;
        this.sendableChannels = sendableChannels;
        this.sendableChannelsView = Collections.unmodifiableSet(sendableChannels);
    }

    public abstract void lateInit();

    protected void registerPendingChannels(ChannelInfoHolder holder) {
        Collection<Identifier> pending = holder.getPendingChannelsNames();
        if (!pending.isEmpty()) {
            this.register(new ArrayList<Identifier>(pending));
            pending.clear();
        }
    }

    protected boolean handle(Identifier channelName, PacketByteBuf originalBuf) {
        this.logger.debug("Handling inbound packet from channel with name \"{}\"", (Object)channelName);
        if (NetworkingImpl.REGISTER_CHANNEL.equals((Object)channelName)) {
            this.receiveRegistration(true, PacketByteBufs.slice((ByteBuf)originalBuf));
            return true;
        }
        if (NetworkingImpl.UNREGISTER_CHANNEL.equals((Object)channelName)) {
            this.receiveRegistration(false, PacketByteBufs.slice((ByteBuf)originalBuf));
            return true;
        }
        @Nullable H handler = this.getHandler(channelName);
        if (handler == null) {
            return false;
        }
        PacketByteBuf buf = PacketByteBufs.slice((ByteBuf)originalBuf);
        try {
            this.receive(handler, buf);
        }
        catch (Throwable ex) {
            this.logger.error("Encountered exception while handling in channel with name \"{}\"", (Object)channelName, (Object)ex);
            throw ex;
        }
        return true;
    }

    protected abstract void receive(H var1, PacketByteBuf var2);

    protected void sendInitialChannelRegistrationPacket() {
        PacketByteBuf buf = this.createRegistrationPacket(this.getReceivableChannels());
        if (buf != null) {
            this.sendPacket(NetworkingImpl.REGISTER_CHANNEL, buf);
        }
    }

    @Nullable
    protected PacketByteBuf createRegistrationPacket(Collection<Identifier> channels) {
        if (channels.isEmpty()) {
            return null;
        }
        PacketByteBuf buf = PacketByteBufs.create();
        boolean first = true;
        for (Identifier channel : channels) {
            if (first) {
                first = false;
            } else {
                buf.writeByte(0);
            }
            buf.writeBytes(channel.toString().getBytes(StandardCharsets.US_ASCII));
        }
        return buf;
    }

    protected void receiveRegistration(boolean register, PacketByteBuf buf) {
        ArrayList<Identifier> ids = new ArrayList<Identifier>();
        StringBuilder active = new StringBuilder();
        while (buf.isReadable()) {
            byte b = buf.readByte();
            if (b != 0) {
                active.append(AsciiString.b2c((byte)b));
                continue;
            }
            this.addId(ids, active);
            active = new StringBuilder();
        }
        this.addId(ids, active);
        this.schedule(register ? () -> this.register(ids) : () -> this.unregister(ids));
    }

    void register(List<Identifier> ids) {
        this.sendableChannels.addAll(ids);
        this.invokeRegisterEvent(ids);
    }

    void unregister(List<Identifier> ids) {
        this.sendableChannels.removeAll(ids);
        this.invokeUnregisterEvent(ids);
    }

    @Override
    public void sendPacket(Packet<?> packet) {
        Objects.requireNonNull(packet, "Packet cannot be null");
        this.connection.send(packet);
    }

    @Override
    public void sendPacket(Packet<?> packet, @Nullable GenericFutureListener<? extends Future<? super Void>> callback) {
        this.sendPacket(packet, (PacketCallbacks)GenericFutureListenerHolder.create(callback));
    }

    @Override
    public void sendPacket(Packet<?> packet, PacketCallbacks callback) {
        Objects.requireNonNull(packet, "Packet cannot be null");
        this.connection.send(packet, callback);
    }

    protected abstract void schedule(Runnable var1);

    protected abstract void invokeRegisterEvent(List<Identifier> var1);

    protected abstract void invokeUnregisterEvent(List<Identifier> var1);

    private void addId(List<Identifier> ids, StringBuilder sb) {
        String literal = sb.toString();
        try {
            ids.add(new Identifier(literal));
        }
        catch (InvalidIdentifierException ex) {
            this.logger.warn("Received invalid channel identifier \"{}\" from connection {}", (Object)literal, (Object)this.connection);
        }
    }

    public Set<Identifier> getSendableChannels() {
        return this.sendableChannelsView;
    }
}

