/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.loot.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.loot.v1.FabricLootSupplier;
import net.fabricmc.fabric.api.loot.v1.FabricLootSupplierBuilder;
import net.fabricmc.fabric.api.loot.v2.FabricLootTableBuilder;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.context.LootContextType;
import net.minecraft.loot.function.LootFunction;

public class BufferingLootTableBuilder
extends FabricLootSupplierBuilder {
    private final List<Consumer<LootTable.Builder>> modifications = new ArrayList<Consumer<LootTable.Builder>>();

    private FabricLootSupplierBuilder addAction(Consumer<LootTable.Builder> action) {
        this.modifications.add(action);
        return this;
    }

    private FabricLootSupplierBuilder addV2Action(Consumer<FabricLootTableBuilder> action) {
        return this.addAction(builder -> action.accept((FabricLootTableBuilder)builder));
    }

    @Override
    public FabricLootSupplierBuilder pool(LootPool.Builder pool) {
        super.pool(pool);
        return this.addAction(builder -> builder.pool(pool));
    }

    @Override
    public FabricLootSupplierBuilder type(LootContextType type) {
        super.type(type);
        return this.addAction(builder -> builder.type(type));
    }

    @Override
    public FabricLootSupplierBuilder apply(LootFunction.Builder function) {
        super.apply(function);
        return this.addAction(builder -> builder.apply(function));
    }

    @Override
    public FabricLootSupplierBuilder withPool(LootPool pool) {
        super.withPool(pool);
        return this.addV2Action(builder -> builder.pool(pool));
    }

    @Override
    public FabricLootSupplierBuilder withFunction(LootFunction function) {
        super.withFunction(function);
        return this.addV2Action(builder -> builder.apply(function));
    }

    @Override
    public FabricLootSupplierBuilder withPools(Collection<LootPool> pools) {
        super.withPools(pools);
        return this.addV2Action(builder -> builder.pools(pools));
    }

    @Override
    public FabricLootSupplierBuilder withFunctions(Collection<LootFunction> functions) {
        super.withFunctions(functions);
        return this.addV2Action(builder -> builder.apply(functions));
    }

    @Override
    public FabricLootSupplierBuilder copyFrom(LootTable supplier, boolean copyType) {
        super.copyFrom(supplier, copyType);
        return this.addV2Action(builder -> {
            FabricLootSupplier extended = (FabricLootSupplier)supplier;
            builder.pools(extended.getPools());
            builder.apply(extended.getFunctions());
            if (copyType) {
                ((LootTable.Builder)builder).type(supplier.getType());
            }
        });
    }

    public void init(LootTable original) {
        super.type(original.getType());
        super.withPools(((FabricLootSupplier)original).getPools());
        super.withFunctions(((FabricLootSupplier)original).getFunctions());
    }

    public void applyTo(LootTable.Builder builder) {
        for (Consumer<LootTable.Builder> modification : this.modifications) {
            modification.accept(builder);
        }
    }
}

