/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.registry.sync.trackers.vanilla;

import java.util.List;
import net.fabricmc.fabric.api.event.registry.RegistryEntryAddedCallback;
import net.fabricmc.fabric.mixin.registry.sync.DebugChunkGeneratorAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.registry.Registries;
import net.minecraft.registry.Registry;
import net.minecraft.util.Identifier;
import net.minecraft.util.math.MathHelper;

public final class BlockInitTracker
implements RegistryEntryAddedCallback<Block> {
    private final Registry<Block> registry;

    private BlockInitTracker(Registry<Block> registry) {
        this.registry = registry;
    }

    public static void register(Registry<Block> registry) {
        BlockInitTracker tracker = new BlockInitTracker(registry);
        RegistryEntryAddedCallback.event(registry).register((Object)tracker);
    }

    @Override
    public void onEntryAdded(int rawId, Identifier id, Block object) {
        assert (id.equals((Object)this.registry.getId((Object)object)));
        object.getLootTableId();
    }

    public static void postFreeze() {
        List<BlockState> blockStateList = Registries.BLOCK.stream().flatMap(block -> block.getStateManager().getStates().stream()).toList();
        int xLength = MathHelper.ceil((float)MathHelper.sqrt((float)blockStateList.size()));
        int zLength = MathHelper.ceil((float)((float)blockStateList.size() / (float)xLength));
        DebugChunkGeneratorAccessor.setBLOCK_STATES(blockStateList);
        DebugChunkGeneratorAccessor.setX_SIDE_LENGTH(xLength);
        DebugChunkGeneratorAccessor.setZ_SIDE_LENGTH(zLength);
    }
}

