/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.registry.sync.trackers;

import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.event.registry.RegistryEntryAddedCallback;
import net.fabricmc.fabric.api.event.registry.RegistryEntryRemovedCallback;
import net.fabricmc.fabric.api.event.registry.RegistryIdRemapCallback;
import net.fabricmc.fabric.impl.registry.sync.RemovableIdList;
import net.minecraft.registry.Registry;
import net.minecraft.util.Identifier;
import net.minecraft.util.collection.IdList;

public class IdListTracker<V, OV>
implements RegistryEntryAddedCallback<V>,
RegistryIdRemapCallback<V>,
RegistryEntryRemovedCallback<V> {
    private final String name;
    private final IdList<OV> mappers;
    private Map<Identifier, OV> removedMapperCache = new HashMap<Identifier, OV>();

    private IdListTracker(String name, IdList<OV> mappers) {
        this.name = name;
        this.mappers = mappers;
    }

    public static <V, OV> void register(Registry<V> registry, String name, IdList<OV> mappers) {
        IdListTracker<V, OV> updater = new IdListTracker<V, OV>(name, mappers);
        RegistryEntryAddedCallback.event(registry).register(updater);
        RegistryIdRemapCallback.event(registry).register(updater);
        RegistryEntryRemovedCallback.event(registry).register(updater);
    }

    @Override
    public void onEntryAdded(int rawId, Identifier id, V object) {
        if (this.removedMapperCache.containsKey(id)) {
            this.mappers.set(this.removedMapperCache.get(id), rawId);
        }
    }

    @Override
    public void onRemap(RegistryIdRemapCallback.RemapState<V> state) {
        ((RemovableIdList)this.mappers).fabric_remapIds(state.getRawIdChangeMap());
    }

    @Override
    public void onEntryRemoved(int rawId, Identifier id, V object) {
        if (this.mappers.get(rawId) != null) {
            this.removedMapperCache.put(id, this.mappers.get(rawId));
            ((RemovableIdList)this.mappers).fabric_removeId(rawId);
        }
    }
}

