/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.networking.server;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.networking.v1.S2CPlayChannelEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.impl.networking.AbstractChanneledNetworkAddon;
import net.fabricmc.fabric.impl.networking.ChannelInfoHolder;
import net.fabricmc.fabric.impl.networking.NetworkingImpl;
import net.fabricmc.fabric.impl.networking.server.ServerNetworkingImpl;
import net.fabricmc.fabric.mixin.networking.accessor.CustomPayloadC2SPacketAccessor;
import net.fabricmc.fabric.mixin.networking.accessor.ServerPlayNetworkHandlerAccessor;
import net.minecraft.network.PacketByteBuf;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.c2s.play.CustomPayloadC2SPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.ServerPlayNetworkHandler;
import net.minecraft.util.Identifier;

public final class ServerPlayNetworkAddon
extends AbstractChanneledNetworkAddon<ServerPlayNetworking.PlayChannelHandler> {
    private final ServerPlayNetworkHandler handler;
    private final MinecraftServer server;
    private boolean sentInitialRegisterPacket;

    public ServerPlayNetworkAddon(ServerPlayNetworkHandler handler, MinecraftServer server) {
        super(ServerNetworkingImpl.PLAY, ((ServerPlayNetworkHandlerAccessor)handler).getConnection(), "ServerPlayNetworkAddon for " + handler.player.getEntityName());
        this.handler = handler;
        this.server = server;
        this.registerPendingChannels((ChannelInfoHolder)this.connection);
        this.receiver.startSession(this);
    }

    @Override
    public void lateInit() {
        for (Map.Entry entry : this.receiver.getHandlers().entrySet()) {
            this.registerChannel(entry.getKey(), (ServerPlayNetworking.PlayChannelHandler)entry.getValue());
        }
        ((ServerPlayConnectionEvents.Init)ServerPlayConnectionEvents.INIT.invoker()).onPlayInit(this.handler, this.server);
    }

    public void onClientReady() {
        ((ServerPlayConnectionEvents.Join)ServerPlayConnectionEvents.JOIN.invoker()).onPlayReady(this.handler, this, this.server);
        this.sendInitialChannelRegistrationPacket();
        this.sentInitialRegisterPacket = true;
    }

    public boolean handle(CustomPayloadC2SPacket packet) {
        CustomPayloadC2SPacketAccessor access = (CustomPayloadC2SPacketAccessor)packet;
        return this.handle(access.getChannel(), access.getData());
    }

    @Override
    protected void receive(ServerPlayNetworking.PlayChannelHandler handler, PacketByteBuf buf) {
        handler.receive(this.server, this.handler.player, this.handler, buf, this);
    }

    @Override
    protected void schedule(Runnable task) {
        this.handler.player.server.execute(task);
    }

    @Override
    public Packet<?> createPacket(Identifier channelName, PacketByteBuf buf) {
        return ServerPlayNetworking.createS2CPacket(channelName, buf);
    }

    @Override
    protected void invokeRegisterEvent(List<Identifier> ids) {
        ((S2CPlayChannelEvents.Register)S2CPlayChannelEvents.REGISTER.invoker()).onChannelRegister(this.handler, this, this.server, ids);
    }

    @Override
    protected void invokeUnregisterEvent(List<Identifier> ids) {
        ((S2CPlayChannelEvents.Unregister)S2CPlayChannelEvents.UNREGISTER.invoker()).onChannelUnregister(this.handler, this, this.server, ids);
    }

    @Override
    protected void handleRegistration(Identifier channelName) {
        PacketByteBuf buf;
        if (this.sentInitialRegisterPacket && (buf = this.createRegistrationPacket(Collections.singleton(channelName))) != null) {
            this.sendPacket(NetworkingImpl.REGISTER_CHANNEL, buf);
        }
    }

    @Override
    protected void handleUnregistration(Identifier channelName) {
        PacketByteBuf buf;
        if (this.sentInitialRegisterPacket && (buf = this.createRegistrationPacket(Collections.singleton(channelName))) != null) {
            this.sendPacket(NetworkingImpl.UNREGISTER_CHANNEL, buf);
        }
    }

    @Override
    protected void invokeDisconnectEvent() {
        ((ServerPlayConnectionEvents.Disconnect)ServerPlayConnectionEvents.DISCONNECT.invoker()).onPlayDisconnect(this.handler, this.server);
        this.receiver.endSession(this);
    }

    @Override
    protected boolean isReservedChannel(Identifier channelName) {
        return NetworkingImpl.isReservedPlayChannel(channelName);
    }
}

