/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.networking.server;

import io.netty.buffer.ByteBuf;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerLoginConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerLoginNetworking;
import net.fabricmc.fabric.impl.networking.AbstractNetworkAddon;
import net.fabricmc.fabric.impl.networking.GenericFutureListenerHolder;
import net.fabricmc.fabric.impl.networking.server.QueryIdFactory;
import net.fabricmc.fabric.impl.networking.server.ServerNetworkingImpl;
import net.fabricmc.fabric.mixin.networking.accessor.LoginQueryResponseC2SPacketAccessor;
import net.fabricmc.fabric.mixin.networking.accessor.ServerLoginNetworkHandlerAccessor;
import net.minecraft.network.ClientConnection;
import net.minecraft.network.PacketByteBuf;
import net.minecraft.network.PacketCallbacks;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.c2s.login.LoginQueryResponseC2SPacket;
import net.minecraft.network.packet.s2c.login.LoginCompressionS2CPacket;
import net.minecraft.network.packet.s2c.login.LoginQueryRequestS2CPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.ServerLoginNetworkHandler;
import net.minecraft.util.Identifier;
import org.jetbrains.annotations.Nullable;

public final class ServerLoginNetworkAddon
extends AbstractNetworkAddon<ServerLoginNetworking.LoginQueryResponseHandler>
implements PacketSender {
    private final ClientConnection connection;
    private final ServerLoginNetworkHandler handler;
    private final MinecraftServer server;
    private final QueryIdFactory queryIdFactory;
    private final Collection<java.util.concurrent.Future<?>> waits = new ConcurrentLinkedQueue();
    private final Map<Integer, Identifier> channels = new ConcurrentHashMap<Integer, Identifier>();
    private boolean firstQueryTick = true;

    public ServerLoginNetworkAddon(ServerLoginNetworkHandler handler) {
        super(ServerNetworkingImpl.LOGIN, "ServerLoginNetworkAddon for " + handler.getConnectionInfo());
        this.connection = ((ServerLoginNetworkHandlerAccessor)handler).getConnection();
        this.handler = handler;
        this.server = ((ServerLoginNetworkHandlerAccessor)handler).getServer();
        this.queryIdFactory = QueryIdFactory.create();
        ((ServerLoginConnectionEvents.Init)ServerLoginConnectionEvents.INIT.invoker()).onLoginInit(handler, this.server);
        this.receiver.startSession(this);
    }

    public boolean queryTick() {
        if (this.firstQueryTick) {
            this.sendCompressionPacket();
            for (Map.Entry<Identifier, ServerLoginNetworking.LoginQueryResponseHandler> entry : ServerNetworkingImpl.LOGIN.getHandlers().entrySet()) {
                ServerLoginNetworking.registerReceiver(this.handler, entry.getKey(), entry.getValue());
            }
            ((ServerLoginConnectionEvents.QueryStart)ServerLoginConnectionEvents.QUERY_START.invoker()).onLoginStart(this.handler, this.server, this, this.waits::add);
            this.firstQueryTick = false;
        }
        AtomicReference error = new AtomicReference();
        this.waits.removeIf(future -> {
            if (!future.isDone()) {
                return false;
            }
            try {
                future.get();
            }
            catch (ExecutionException ex) {
                Throwable caught = ex.getCause();
                error.getAndUpdate(oldEx -> {
                    if (oldEx == null) {
                        return caught;
                    }
                    oldEx.addSuppressed(caught);
                    return oldEx;
                });
            }
            catch (InterruptedException | CancellationException exception) {
                // empty catch block
            }
            return true;
        });
        return this.channels.isEmpty() && this.waits.isEmpty();
    }

    private void sendCompressionPacket() {
        if (this.server.getNetworkCompressionThreshold() >= 0 && !this.connection.isLocal()) {
            this.connection.send((Packet)new LoginCompressionS2CPacket(this.server.getNetworkCompressionThreshold()), PacketCallbacks.always(() -> this.connection.setCompressionThreshold(this.server.getNetworkCompressionThreshold(), true)));
        }
    }

    public boolean handle(LoginQueryResponseC2SPacket packet) {
        LoginQueryResponseC2SPacketAccessor access = (LoginQueryResponseC2SPacketAccessor)packet;
        return this.handle(access.getQueryId(), access.getResponse());
    }

    private boolean handle(int queryId, @Nullable PacketByteBuf originalBuf) {
        this.logger.debug("Handling inbound login query with id {}", (Object)queryId);
        Identifier channel = this.channels.remove(queryId);
        if (channel == null) {
            this.logger.warn("Query ID {} was received but no query has been associated in {}!", (Object)queryId, (Object)this.connection);
            return false;
        }
        boolean understood = originalBuf != null;
        @Nullable ServerLoginNetworking.LoginQueryResponseHandler handler = ServerNetworkingImpl.LOGIN.getHandler(channel);
        if (handler == null) {
            return false;
        }
        PacketByteBuf buf = understood ? PacketByteBufs.slice((ByteBuf)originalBuf) : PacketByteBufs.empty();
        try {
            handler.receive(this.server, this.handler, understood, buf, this.waits::add, this);
        }
        catch (Throwable ex) {
            this.logger.error("Encountered exception while handling in channel \"{}\"", (Object)channel, (Object)ex);
            throw ex;
        }
        return true;
    }

    @Override
    public Packet<?> createPacket(Identifier channelName, PacketByteBuf buf) {
        int queryId = this.queryIdFactory.nextId();
        LoginQueryRequestS2CPacket ret = new LoginQueryRequestS2CPacket(queryId, channelName, buf);
        return ret;
    }

    @Override
    public void sendPacket(Packet<?> packet) {
        Objects.requireNonNull(packet, "Packet cannot be null");
        this.connection.send(packet);
    }

    @Override
    public void sendPacket(Packet<?> packet, @Nullable GenericFutureListener<? extends Future<? super Void>> callback) {
        this.sendPacket(packet, (PacketCallbacks)GenericFutureListenerHolder.create(callback));
    }

    @Override
    public void sendPacket(Packet<?> packet, PacketCallbacks callback) {
        Objects.requireNonNull(packet, "Packet cannot be null");
        this.connection.send(packet, callback);
    }

    public void registerOutgoingPacket(LoginQueryRequestS2CPacket packet) {
        this.channels.put(packet.getQueryId(), packet.getChannel());
    }

    @Override
    protected void handleRegistration(Identifier channelName) {
    }

    @Override
    protected void handleUnregistration(Identifier channelName) {
    }

    @Override
    protected void invokeDisconnectEvent() {
        ((ServerLoginConnectionEvents.Disconnect)ServerLoginConnectionEvents.DISCONNECT.invoker()).onLoginDisconnect(this.handler, this.server);
        this.receiver.endSession(this);
    }

    public void handlePlayTransition() {
        this.receiver.endSession(this);
    }

    @Override
    protected boolean isReservedChannel(Identifier channelName) {
        return false;
    }
}

