/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.networking;

import java.util.ArrayList;
import java.util.Set;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerLoginConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerLoginNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.impl.networking.ChannelInfoHolder;
import net.fabricmc.fabric.mixin.networking.accessor.ServerLoginNetworkHandlerAccessor;
import net.minecraft.network.ClientConnection;
import net.minecraft.network.PacketByteBuf;
import net.minecraft.util.Identifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetworkingImpl {
    public static final String MOD_ID = "fabric-networking-api-v1";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"fabric-networking-api-v1");
    public static final Identifier REGISTER_CHANNEL = new Identifier("minecraft", "register");
    public static final Identifier UNREGISTER_CHANNEL = new Identifier("minecraft", "unregister");
    public static final Identifier EARLY_REGISTRATION_CHANNEL = new Identifier("fabric-networking-api-v1", "early_registration");

    public static void init() {
        ServerLoginConnectionEvents.QUERY_START.register((handler, server, sender, synchronizer) -> {
            PacketByteBuf buf = PacketByteBufs.create();
            Set<Identifier> channelsNames = ServerPlayNetworking.getGlobalReceivers();
            buf.writeVarInt(channelsNames.size());
            for (Identifier id : channelsNames) {
                buf.writeIdentifier(id);
            }
            sender.sendPacket(EARLY_REGISTRATION_CHANNEL, buf);
            LOGGER.debug("Sent accepted channels to the client for \"{}\"", (Object)handler.getConnectionInfo());
        });
        ServerLoginNetworking.registerGlobalReceiver(EARLY_REGISTRATION_CHANNEL, (server, handler, understood, buf, synchronizer, sender) -> {
            if (!understood) {
                return;
            }
            int n = buf.readVarInt();
            ArrayList<Identifier> ids = new ArrayList<Identifier>(n);
            for (int i = 0; i < n; ++i) {
                ids.add(buf.readIdentifier());
            }
            ClientConnection connection = ((ServerLoginNetworkHandlerAccessor)handler).getConnection();
            ((ChannelInfoHolder)connection).getPendingChannelsNames().addAll(ids);
            LOGGER.debug("Received accepted channels from the client for \"{}\"", (Object)handler.getConnectionInfo());
        });
    }

    public static boolean isReservedPlayChannel(Identifier channelName) {
        return channelName.equals((Object)REGISTER_CHANNEL) || channelName.equals((Object)UNREGISTER_CHANNEL);
    }
}

