/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.biome.v1;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectionContext;
import net.fabricmc.fabric.impl.biome.modification.BuiltInRegistryKeys;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnGroup;
import net.minecraft.registry.RegistryKey;
import net.minecraft.registry.tag.TagKey;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.SpawnSettings;
import net.minecraft.world.dimension.DimensionOptions;

public final class BiomeSelectors {
    private BiomeSelectors() {
    }

    public static Predicate<BiomeSelectionContext> all() {
        return context -> true;
    }

    public static Predicate<BiomeSelectionContext> vanilla() {
        return context -> context.getBiomeKey().getValue().getNamespace().equals("minecraft") && BuiltInRegistryKeys.isBuiltinBiome(context.getBiomeKey());
    }

    public static Predicate<BiomeSelectionContext> foundInOverworld() {
        return context -> context.canGenerateIn((RegistryKey<DimensionOptions>)DimensionOptions.OVERWORLD);
    }

    public static Predicate<BiomeSelectionContext> foundInTheNether() {
        return context -> context.canGenerateIn((RegistryKey<DimensionOptions>)DimensionOptions.NETHER);
    }

    public static Predicate<BiomeSelectionContext> foundInTheEnd() {
        return context -> context.canGenerateIn((RegistryKey<DimensionOptions>)DimensionOptions.END);
    }

    public static Predicate<BiomeSelectionContext> tag(TagKey<Biome> tag) {
        return context -> context.hasTag(tag);
    }

    @SafeVarargs
    public static Predicate<BiomeSelectionContext> excludeByKey(RegistryKey<Biome> ... keys) {
        return BiomeSelectors.excludeByKey((Collection<RegistryKey<Biome>>)ImmutableSet.copyOf((Object[])keys));
    }

    public static Predicate<BiomeSelectionContext> excludeByKey(Collection<RegistryKey<Biome>> keys) {
        return context -> !keys.contains(context.getBiomeKey());
    }

    @SafeVarargs
    public static Predicate<BiomeSelectionContext> includeByKey(RegistryKey<Biome> ... keys) {
        return BiomeSelectors.includeByKey((Collection<RegistryKey<Biome>>)ImmutableSet.copyOf((Object[])keys));
    }

    public static Predicate<BiomeSelectionContext> includeByKey(Collection<RegistryKey<Biome>> keys) {
        return context -> keys.contains(context.getBiomeKey());
    }

    public static Predicate<BiomeSelectionContext> spawnsOneOf(EntityType<?> ... entityTypes) {
        return BiomeSelectors.spawnsOneOf(ImmutableSet.copyOf((Object[])entityTypes));
    }

    public static Predicate<BiomeSelectionContext> spawnsOneOf(Set<EntityType<?>> entityTypes) {
        return context -> {
            SpawnSettings spawnSettings = context.getBiome().getSpawnSettings();
            for (SpawnGroup spawnGroup : SpawnGroup.values()) {
                for (SpawnSettings.SpawnEntry spawnEntry : spawnSettings.getSpawnEntries(spawnGroup).getEntries()) {
                    if (!entityTypes.contains(spawnEntry.type)) continue;
                    return true;
                }
            }
            return false;
        };
    }
}

