/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.biome.v1;

import java.util.List;
import java.util.Optional;
import net.minecraft.registry.RegistryKey;
import net.minecraft.registry.entry.RegistryEntry;
import net.minecraft.registry.entry.RegistryEntryList;
import net.minecraft.registry.tag.TagKey;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.dimension.DimensionOptions;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.PlacedFeature;
import net.minecraft.world.gen.structure.Structure;

public interface BiomeSelectionContext {
    public RegistryKey<Biome> getBiomeKey();

    public Biome getBiome();

    public RegistryEntry<Biome> getBiomeRegistryEntry();

    default public boolean hasFeature(RegistryKey<ConfiguredFeature<?, ?>> key) {
        List featureSteps = this.getBiome().getGenerationSettings().getFeatures();
        for (RegistryEntryList featureSuppliers : featureSteps) {
            for (RegistryEntry featureSupplier : featureSuppliers) {
                if (!((PlacedFeature)featureSupplier.value()).getDecoratedFeatures().anyMatch(cf -> this.getFeatureKey((ConfiguredFeature<?, ?>)cf).orElse(null) == key)) continue;
                return true;
            }
        }
        return false;
    }

    default public boolean hasPlacedFeature(RegistryKey<PlacedFeature> key) {
        List featureSteps = this.getBiome().getGenerationSettings().getFeatures();
        for (RegistryEntryList featureSuppliers : featureSteps) {
            for (RegistryEntry featureSupplier : featureSuppliers) {
                if (this.getPlacedFeatureKey((PlacedFeature)featureSupplier.value()).orElse(null) != key) continue;
                return true;
            }
        }
        return false;
    }

    public Optional<RegistryKey<ConfiguredFeature<?, ?>>> getFeatureKey(ConfiguredFeature<?, ?> var1);

    public Optional<RegistryKey<PlacedFeature>> getPlacedFeatureKey(PlacedFeature var1);

    public boolean validForStructure(RegistryKey<Structure> var1);

    public Optional<RegistryKey<Structure>> getStructureKey(Structure var1);

    public boolean canGenerateIn(RegistryKey<DimensionOptions> var1);

    public boolean hasTag(TagKey<Biome> var1);
}

